/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.ClonableTrack;
import com.jme3.animation.Track;
import com.jme3.animation.TrackInfo;
import com.jme3.audio.AudioNode;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AudioTrack
implements ClonableTrack {
    private static final Logger logger = Logger.getLogger(AudioTrack.class.getName());
    private AudioNode audio;
    private float startOffset = 0.0f;
    private float length = 0.0f;
    private boolean initialized = false;
    private boolean started = false;

    public AudioTrack() {
    }

    public AudioTrack(AudioNode audio, float length) {
        this.audio = audio;
        this.length = length;
        this.setUserData(this);
    }

    public AudioTrack(AudioNode audio, float length, float startOffset) {
        this(audio, length);
        this.startOffset = startOffset;
    }

    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
        if (!this.initialized) {
            control.addListener(new OnEndListener());
            this.initialized = true;
        }
        if (!this.started && time >= this.startOffset) {
            this.started = true;
            this.audio.playInstance();
        }
    }

    private void stop() {
        this.audio.stop();
        this.started = false;
    }

    public float getLength() {
        return this.length;
    }

    public Track clone() {
        return new AudioTrack(this.audio, this.length, this.startOffset);
    }

    public Track cloneForSpatial(Spatial spatial) {
        AudioTrack audioTrack = new AudioTrack();
        audioTrack.length = this.length;
        audioTrack.startOffset = this.startOffset;
        audioTrack.audio = this.findAudio(spatial);
        if (audioTrack.audio == null) {
            logger.log(Level.WARNING, "{0} was not found in {1} or is not bound to this track", new Object[]{this.audio.getName(), spatial.getName()});
            audioTrack.audio = this.audio;
        }
        this.setUserData(audioTrack);
        return audioTrack;
    }

    private AudioNode findAudio(Spatial spat) {
        if (spat instanceof AudioNode) {
            AudioNode em = (AudioNode)spat;
            TrackInfo t = (TrackInfo)em.getUserData("TrackInfo");
            if (t != null && t.getTracks().contains(this)) {
                return em;
            }
            return null;
        }
        if (spat instanceof Node) {
            for (Spatial child : ((Node)spat).getChildren()) {
                AudioNode em = this.findAudio(child);
                if (em == null) continue;
                return em;
            }
        }
        return null;
    }

    private void setUserData(AudioTrack audioTrack) {
        TrackInfo data = (TrackInfo)audioTrack.audio.getUserData("TrackInfo");
        if (data == null) {
            data = new TrackInfo();
            audioTrack.audio.setUserData("TrackInfo", data);
        }
        data.addTrack(audioTrack);
    }

    public void cleanUp() {
        TrackInfo t = (TrackInfo)this.audio.getUserData("TrackInfo");
        t.getTracks().remove(this);
        if (!t.getTracks().isEmpty()) {
            this.audio.setUserData("TrackInfo", null);
        }
    }

    public AudioNode getAudio() {
        return this.audio;
    }

    public void setAudio(AudioNode audio) {
        if (this.audio != null) {
            TrackInfo data = (TrackInfo)audio.getUserData("TrackInfo");
            data.getTracks().remove(this);
        }
        this.audio = audio;
        this.setUserData(this);
    }

    public float getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(float startOffset) {
        this.startOffset = startOffset;
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.audio, "audio", null);
        out.write(this.length, "length", 0.0f);
        out.write(this.startOffset, "startOffset", 0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.audio = (AudioNode)in.readSavable("audio", null);
        this.length = in.readFloat("length", this.length);
        this.startOffset = in.readFloat("startOffset", 0.0f);
    }

    private class OnEndListener
    implements AnimEventListener {
        private OnEndListener() {
        }

        public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
            AudioTrack.this.stop();
        }

        public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
            AudioTrack.this.stop();
        }
    }
}

