/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.FlacFormatException;
import de.jarnbjo.flac.MetadataBlock;
import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;

public class StreamInfo
extends MetadataBlock {
    private int minimumBlockSize;
    private int maximumBlockSize;
    private int minimumFrameSize;
    private int maximumFrameSize;
    private int sampleRate;
    private int channels;
    private int bitsPerSample;
    private long totalSamples;

    protected StreamInfo(BitInputStream source) throws FlacFormatException, IOException {
        int length = source.getInt(24);
        this.minimumBlockSize = source.getInt(16);
        this.maximumBlockSize = source.getInt(16);
        this.minimumFrameSize = source.getInt(24);
        this.maximumFrameSize = source.getInt(24);
        this.sampleRate = source.getInt(20);
        this.channels = source.getInt(3) + 1;
        this.bitsPerSample = source.getInt(5) + 1;
        this.totalSamples = source.getLong(36);
        source.getLong(64);
        source.getLong(64);
    }

    public int getMinimumBlockSize() {
        return this.minimumBlockSize;
    }

    public int getMaximumBlockSize() {
        return this.maximumBlockSize;
    }

    public int getMinimumFrameSize() {
        return this.minimumFrameSize;
    }

    public int getMaximumFrameSize() {
        return this.maximumFrameSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }
}

