/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise.filter;

import com.jme3.terrain.noise.filter.AbstractFilter;
import java.nio.FloatBuffer;

public class ThermalErodeFilter
extends AbstractFilter {
    private float talus;
    private float c;

    public ThermalErodeFilter setC(float c) {
        this.c = c;
        return this;
    }

    public ThermalErodeFilter setTalus(float talus) {
        this.talus = talus;
        return this;
    }

    public int getMargin(int size, int margin) {
        return super.getMargin(size, margin) + 1;
    }

    public FloatBuffer filter(float sx, float sy, float base, FloatBuffer buffer, int workSize) {
        float[] ga = buffer.array();
        float[] sa = new float[workSize * workSize];
        int[] idxrel = new int[]{-workSize - 1, -workSize + 1, workSize - 1, workSize + 1};
        for (int y = 0; y < workSize; ++y) {
            for (int x = 0; x < workSize; ++x) {
                int j;
                int idx;
                int n = idx = y * workSize + x;
                ga[n] = ga[n] + sa[idx];
                sa[idx] = 0.0f;
                float[] deltas = new float[idxrel.length];
                float deltaMax = this.talus;
                float deltaTotal = 0.0f;
                for (j = 0; j < idxrel.length; ++j) {
                    float dj;
                    if (idx + idxrel[j] <= 0 || idx + idxrel[j] >= ga.length || !((dj = ga[idx] - ga[idx + idxrel[j]]) > this.talus)) continue;
                    deltas[j] = dj;
                    deltaTotal += dj;
                    if (!(dj > deltaMax)) continue;
                    deltaMax = dj;
                }
                for (j = 0; j < idxrel.length; ++j) {
                    if (deltas[j] != 0.0f) {
                        float d = this.c * (deltaMax - this.talus) * deltas[j] / deltaTotal;
                        if (d > ga[idx] + sa[idx]) {
                            d = ga[idx] + sa[idx];
                        }
                        int n2 = idx;
                        sa[n2] = sa[n2] - d;
                        int n3 = idx + idxrel[j];
                        sa[n3] = sa[n3] + d;
                    }
                    deltas[j] = 0.0f;
                }
            }
        }
        return buffer;
    }
}

