/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.lodcalc.util;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Matrix4f;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class EntropyComputeUtil {
    public static float computeLodEntropy(Mesh terrainBlock, IntBuffer lodIndices) {
        BoundingBox bbox = (BoundingBox)terrainBlock.getBound();
        FloatBuffer positions = terrainBlock.getFloatBuffer(VertexBuffer.Type.Position);
        Vector3f pos = new Vector3f();
        Vector3f dir = new Vector3f(0.0f, -1.0f, 0.0f);
        Ray ray = new Ray(pos, dir);
        CollisionResults results = new CollisionResults();
        VertexBuffer originalIndices = terrainBlock.getBuffer(VertexBuffer.Type.Index);
        terrainBlock.clearBuffer(VertexBuffer.Type.Index);
        terrainBlock.setBuffer(VertexBuffer.Type.Index, 3, lodIndices);
        terrainBlock.createCollisionData();
        float entropy = 0.0f;
        for (int i = 0; i < positions.limit() / 3; ++i) {
            BufferUtils.populateFromBuffer((Vector3f)pos, (FloatBuffer)positions, (int)i);
            float realHeight = pos.y;
            pos.addLocal(0.0f, bbox.getYExtent(), 0.0f);
            ray.setOrigin(pos);
            results.clear();
            terrainBlock.collideWith((Collidable)ray, Matrix4f.IDENTITY, (BoundingVolume)bbox, results);
            if (results.size() <= 0) continue;
            Vector3f contactPoint = results.getClosestCollision().getContactPoint();
            float delta = Math.abs(realHeight - contactPoint.y);
            entropy = Math.max(delta, entropy);
        }
        terrainBlock.clearBuffer(VertexBuffer.Type.Index);
        terrainBlock.setBuffer(originalIndices);
        return entropy;
    }
}

