/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.lodcalc;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveLodCalculator
implements LodCalculator {
    private Camera cam;
    private float[] entropyDistances;
    private float pixelError;

    public PerspectiveLodCalculator() {
    }

    public PerspectiveLodCalculator(Camera cam, float pixelError) {
        this.cam = cam;
        this.pixelError = pixelError;
    }

    private float getCameraConstant(Camera cam, float pixelLimit) {
        float n = cam.getFrustumNear();
        float t = FastMath.abs((float)cam.getFrustumTop());
        float A = n / t;
        float v_res = cam.getHeight();
        float T = 2.0f * pixelLimit / v_res;
        return A / T;
    }

    @Override
    public boolean calculateLod(TerrainPatch patch, List<Vector3f> locations, HashMap<String, UpdatedTerrainPatch> updates) {
        int i;
        if (this.entropyDistances == null) {
            float[] lodEntropies = patch.getLodEntropies();
            this.entropyDistances = new float[lodEntropies.length];
            float cameraConstant = this.getCameraConstant(this.cam, this.pixelError);
            for (i = 0; i < lodEntropies.length; ++i) {
                this.entropyDistances[i] = lodEntropies[i] * cameraConstant;
            }
        }
        Vector3f patchPos = this.getCenterLocation(patch);
        float distance = patchPos.distance(locations.get(0));
        for (i = 0; i <= patch.getMaxLod(); ++i) {
            if (!(distance < this.entropyDistances[i]) && i != patch.getMaxLod()) continue;
            boolean reIndexNeeded = false;
            if (i != patch.getLod()) {
                reIndexNeeded = true;
            }
            int prevLOD = patch.getLod();
            UpdatedTerrainPatch utp = updates.get(patch.getName());
            if (utp == null) {
                utp = new UpdatedTerrainPatch(patch);
                updates.put(utp.getName(), utp);
            }
            utp.setNewLod(i);
            utp.setPreviousLod(prevLOD);
            return reIndexNeeded;
        }
        return false;
    }

    public Vector3f getCenterLocation(TerrainPatch patch) {
        Vector3f loc = patch.getWorldTranslation().clone();
        loc.x += (float)(patch.getSize() / 2);
        loc.z += (float)(patch.getSize() / 2);
        return loc;
    }

    @Override
    public LodCalculator clone() {
        try {
            return (LodCalculator)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void write(JmeExporter ex) throws IOException {
    }

    public void read(JmeImporter im) throws IOException {
    }

    @Override
    public boolean usesVariableLod() {
        return true;
    }

    public float getPixelError() {
        return this.pixelError;
    }

    public void setPixelError(float pixelError) {
        this.pixelError = pixelError;
    }

    public void setCam(Camera cam) {
        this.cam = cam;
    }

    @Override
    public void turnOffLod() {
    }

    @Override
    public boolean isLodOff() {
        return false;
    }

    @Override
    public void turnOnLod() {
    }
}

