/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.scene.VertexBuffer;
import com.jme3.terrain.geomipmap.TerrainPatch;
import java.nio.IntBuffer;

public class UpdatedTerrainPatch {
    private TerrainPatch updatedPatch;
    private int newLod;
    private int previousLod;
    private int rightLod;
    private int topLod;
    private int leftLod;
    private int bottomLod;
    private IntBuffer newIndexBuffer;
    private boolean fixEdges = false;

    public UpdatedTerrainPatch(TerrainPatch updatedPatch) {
        this.updatedPatch = updatedPatch;
    }

    public UpdatedTerrainPatch(TerrainPatch updatedPatch, int newLod) {
        this.updatedPatch = updatedPatch;
        this.newLod = newLod;
    }

    public String getName() {
        return this.updatedPatch.getName();
    }

    protected boolean lodChanged() {
        return this.previousLod != this.newLod;
    }

    protected TerrainPatch getUpdatedPatch() {
        return this.updatedPatch;
    }

    protected void setUpdatedPatch(TerrainPatch updatedPatch) {
        this.updatedPatch = updatedPatch;
    }

    protected int getNewLod() {
        return this.newLod;
    }

    public void setNewLod(int newLod) {
        this.newLod = newLod;
        if (this.newLod < 0) {
            throw new IllegalArgumentException("newLod cannot be less than zero, was: " + newLod);
        }
    }

    protected void setNewIndexBuffer(IntBuffer newIndexBuffer) {
        this.newIndexBuffer = newIndexBuffer;
    }

    protected int getRightLod() {
        return this.rightLod;
    }

    protected void setRightLod(int rightLod) {
        this.rightLod = rightLod;
    }

    protected int getTopLod() {
        return this.topLod;
    }

    protected void setTopLod(int topLod) {
        this.topLod = topLod;
    }

    protected int getLeftLod() {
        return this.leftLod;
    }

    protected void setLeftLod(int leftLod) {
        this.leftLod = leftLod;
    }

    protected int getBottomLod() {
        return this.bottomLod;
    }

    protected void setBottomLod(int bottomLod) {
        this.bottomLod = bottomLod;
    }

    public boolean isReIndexNeeded() {
        return this.lodChanged() || this.isFixEdges();
    }

    public boolean isFixEdges() {
        return this.fixEdges;
    }

    public void setFixEdges(boolean fixEdges) {
        this.fixEdges = fixEdges;
    }

    public void setPreviousLod(int previousLod) {
        this.previousLod = previousLod;
    }

    public void updateAll() {
        this.updatedPatch.setLod(this.newLod);
        this.updatedPatch.setLodRight(this.rightLod);
        this.updatedPatch.setLodTop(this.topLod);
        this.updatedPatch.setLodLeft(this.leftLod);
        this.updatedPatch.setLodBottom(this.bottomLod);
        if (this.newIndexBuffer != null && this.isReIndexNeeded()) {
            this.updatedPatch.setPreviousLod(this.previousLod);
            this.updatedPatch.getMesh().clearBuffer(VertexBuffer.Type.Index);
            this.updatedPatch.getMesh().setBuffer(VertexBuffer.Type.Index, 3, this.newIndexBuffer);
        }
    }
}

