/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.DistanceLodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainLodControl
extends AbstractControl {
    private Terrain terrain;
    protected List<Camera> cameras;
    private List<Vector3f> cameraLocations = new ArrayList<Vector3f>();
    protected LodCalculator lodCalculator;
    private boolean hasResetLod = false;
    private HashMap<String, UpdatedTerrainPatch> updatedPatches;
    private final Object updatePatchesLock = new Object();
    protected List<Vector3f> lastCameraLocations;
    private AtomicBoolean lodCalcRunning = new AtomicBoolean(false);
    private int lodOffCount = 0;
    protected ExecutorService executor;
    protected Future<HashMap<String, UpdatedTerrainPatch>> indexer;

    public TerrainLodControl() {
    }

    public TerrainLodControl(Terrain terrain, Camera camera) {
        ArrayList<Camera> cams = new ArrayList<Camera>();
        cams.add(camera);
        this.terrain = terrain;
        this.cameras = cams;
        this.lodCalculator = new DistanceLodCalculator(65, 2.7f);
    }

    public TerrainLodControl(Terrain terrain, List<Camera> cameras) {
        this.terrain = terrain;
        this.cameras = cameras;
        this.lodCalculator = new DistanceLodCalculator(65, 2.7f);
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    protected ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread th = new Thread(r);
                th.setName("jME Terrain Thread");
                th.setDaemon(true);
                return th;
            }
        });
    }

    protected void controlUpdate(float tpf) {
        if (this.lodCalculator == null) {
            return;
        }
        if (!this.enabled && !this.hasResetLod) {
            this.hasResetLod = true;
            this.lodCalculator.turnOffLod();
        }
        if (this.cameras != null) {
            if (this.cameraLocations.isEmpty() && !this.cameras.isEmpty()) {
                for (Camera c : this.cameras) {
                    this.cameraLocations.add(c.getLocation());
                }
            }
            this.updateLOD(this.cameraLocations, this.lodCalculator);
        }
    }

    protected void updateLOD(List<Vector3f> locations, LodCalculator lodCalculator) {
        this.updateQuadLODs();
        if (lodCalculator.isLodOff()) {
            if (this.lodOffCount == 1) {
                return;
            }
            ++this.lodOffCount;
        } else {
            this.lodOffCount = 0;
        }
        if (this.lastCameraLocations != null) {
            if (this.lastCameraLocationsTheSame(locations) && !lodCalculator.isLodOff()) {
                return;
            }
        } else {
            this.lastCameraLocations = this.cloneVectorList(locations);
            return;
        }
        this.lastCameraLocations = this.cloneVectorList(locations);
        if (this.isLodCalcRunning()) {
            return;
        }
        this.setLodCalcRunning(true);
        if (this.executor == null) {
            this.executor = this.createExecutorService();
        }
        this.prepareTerrain();
        UpdateLOD updateLodThread = this.getLodThread(locations, lodCalculator);
        this.indexer = this.executor.submit(updateLodThread);
    }

    protected void prepareTerrain() {
        TerrainQuad terrain = (TerrainQuad)this.getSpatial();
        terrain.cacheTerrainTransforms();
    }

    protected UpdateLOD getLodThread(List<Vector3f> locations, LodCalculator lodCalculator) {
        return new UpdateLOD(locations, lodCalculator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuadLODs() {
        if (this.indexer != null && this.indexer.isDone()) {
            try {
                HashMap<String, UpdatedTerrainPatch> updated = this.indexer.get();
                if (updated != null) {
                    for (UpdatedTerrainPatch utp : updated.values()) {
                        utp.updateAll();
                    }
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TerrainLodControl.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(TerrainLodControl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.indexer = null;
            }
        }
    }

    private boolean lastCameraLocationsTheSame(List<Vector3f> locations) {
        boolean theSame = true;
        for (Vector3f l : locations) {
            for (Vector3f v : this.lastCameraLocations) {
                if (v.equals((Object)l)) continue;
                theSame = false;
                return false;
            }
        }
        return theSame;
    }

    protected synchronized boolean isLodCalcRunning() {
        return this.lodCalcRunning.get();
    }

    protected synchronized void setLodCalcRunning(boolean running) {
        this.lodCalcRunning.set(running);
    }

    private List<Vector3f> cloneVectorList(List<Vector3f> locations) {
        ArrayList<Vector3f> cloned = new ArrayList<Vector3f>();
        for (Vector3f l : locations) {
            cloned.add(l.clone());
        }
        return cloned;
    }

    public Control cloneForSpatial(Spatial spatial) {
        if (spatial instanceof Terrain) {
            ArrayList<Camera> cameraClone = new ArrayList<Camera>();
            if (this.cameras != null) {
                for (Camera c : this.cameras) {
                    cameraClone.add(c);
                }
            }
            TerrainLodControl cloned = new TerrainLodControl((Terrain)spatial, cameraClone);
            cloned.setLodCalculator(this.lodCalculator.clone());
            return cloned;
        }
        return null;
    }

    public void setCamera(Camera camera) {
        ArrayList<Camera> cams = new ArrayList<Camera>();
        cams.add(camera);
        this.setCameras(cams);
    }

    public void setCameras(List<Camera> cameras) {
        this.cameras = cameras;
        this.cameraLocations.clear();
        for (Camera c : cameras) {
            this.cameraLocations.add(c.getLocation());
        }
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        if (spatial instanceof Terrain) {
            this.terrain = (Terrain)spatial;
        }
    }

    public void setTerrain(Terrain terrain) {
        this.terrain = terrain;
    }

    public LodCalculator getLodCalculator() {
        return this.lodCalculator;
    }

    public void setLodCalculator(LodCalculator lodCalculator) {
        this.lodCalculator = lodCalculator;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.hasResetLod = false;
        } else {
            this.hasResetLod = true;
            this.lodCalculator.turnOnLod();
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write((Savable)((Node)this.terrain), "terrain", null);
        oc.write((Savable)this.lodCalculator, "lodCalculator", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.terrain = (Terrain)ic.readSavable("terrain", null);
        this.lodCalculator = (LodCalculator)ic.readSavable("lodCalculator", (Savable)new DistanceLodCalculator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateLOD
    implements Callable<HashMap<String, UpdatedTerrainPatch>> {
        protected List<Vector3f> camLocations;
        protected LodCalculator lodCalculator;

        protected UpdateLOD(List<Vector3f> camLocations, LodCalculator lodCalculator) {
            this.camLocations = camLocations;
            this.lodCalculator = lodCalculator;
        }

        @Override
        public HashMap<String, UpdatedTerrainPatch> call() throws Exception {
            TerrainLodControl.this.setLodCalcRunning(true);
            TerrainQuad terrainQuad = (TerrainQuad)TerrainLodControl.this.getSpatial();
            HashMap<String, UpdatedTerrainPatch> updated = new HashMap<String, UpdatedTerrainPatch>();
            boolean lodChanged = terrainQuad.calculateLod(this.camLocations, updated, this.lodCalculator);
            if (!lodChanged) {
                TerrainLodControl.this.setLodCalcRunning(false);
                return null;
            }
            terrainQuad.findNeighboursLod(updated);
            terrainQuad.fixEdges(updated);
            terrainQuad.reIndexPages(updated, this.lodCalculator.usesVariableLod());
            TerrainLodControl.this.setLodCalcRunning(false);
            return updated;
        }
    }
}

