/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.jgrid.ui;

import com.guigarage.jgrid.ui.BasicGridUI;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class MacOsGridUI
extends BasicGridUI {
    private BufferedImage offScreenImage;
    private Stroke unselectedBorderStroke = new BasicStroke(1.8f);
    private Stroke selectedBorderForegroundStroke = new BasicStroke(4.0f);
    private Stroke selectedBorderBackgroundStroke = new BasicStroke(6.0f);
    private int selectionArcWidth = 20;
    private int selectionArcHeight = 20;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.grid.setOpaque(true);
        this.grid.setBackground(new Color(103, 103, 103));
        this.grid.setForeground(Color.BLACK);
        this.grid.setCellBackground(new Color(180, 180, 180));
        this.grid.setSelectionBorderColor(new Color(248, 211, 80));
        this.grid.setSelectionForeground(Color.WHITE);
        this.grid.setSelectionBackground(new Color(43, 43, 43));
    }

    @Override
    protected void paintCell(Graphics g, JComponent c, int index, Rectangle bounds, int leadIndex) {
        boolean isSelected = this.grid.getSelectionModel().isSelectedIndex(index);
        if (this.offScreenImage == null || this.offScreenImage.getWidth() != bounds.width || this.offScreenImage.getHeight() != bounds.height) {
            this.offScreenImage = new BufferedImage(bounds.width, bounds.height, 2);
        }
        Graphics2D g2 = this.offScreenImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, this.offScreenImage.getWidth(), this.offScreenImage.getHeight());
        g2.setComposite(AlphaComposite.SrcOver);
        if (isSelected) {
            g2.setColor(this.grid.getSelectionBackground());
        } else {
            g2.setColor(this.grid.getCellBackground());
        }
        g2.fillRoundRect(0, 0, bounds.width, bounds.height, this.selectionArcWidth, this.selectionArcHeight);
        g2.setComposite(AlphaComposite.SrcIn);
        super.paintCell(g2, c, index, new Rectangle(0, 0, bounds.width, bounds.height), leadIndex);
        g2.dispose();
        g.drawImage(this.offScreenImage, bounds.x, bounds.y, null);
    }

    @Override
    protected void paintCellBorder(Graphics g, JComponent c, int index, Rectangle bounds, int leadIndex) {
        boolean isSelected = this.grid.getSelectionModel().isSelectedIndex(index);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (isSelected) {
            g2.setColor(this.grid.getSelectionBackground());
            g2.setStroke(this.selectedBorderBackgroundStroke);
            g2.drawRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, this.selectionArcWidth, this.selectionArcHeight);
            g2.setColor(this.grid.getSelectionBorderColor());
            g2.setStroke(this.selectedBorderForegroundStroke);
            g2.drawRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, this.selectionArcWidth, this.selectionArcHeight);
        } else {
            g2.setColor(this.grid.getCellBackground());
            g2.setStroke(this.unselectedBorderStroke);
            g2.drawRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, this.selectionArcWidth, this.selectionArcHeight);
        }
        g2.dispose();
    }
}

