/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.jgrid.ui;

import com.guigarage.jgrid.JGrid;
import com.guigarage.jgrid.ui.ListSelectionUtilities;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BasicGridUIHandler
implements PropertyChangeListener,
MouseListener,
KeyListener,
ListSelectionListener,
ListDataListener,
ComponentListener {
    private JGrid grid;

    public BasicGridUIHandler(JGrid grid) {
        this.grid = grid;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.grid.getUI().markCellBoundsAsDirty();
        this.grid.repaint();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.grid.getUI().markCellBoundsAsDirty();
        this.grid.repaint();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.grid.getUI().markCellBoundsAsDirty();
        for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
            Rectangle cellBounds = this.grid.getCellBounds(i);
            if (cellBounds == null) continue;
            this.grid.repaint();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.grid.getUI().markCellBoundsAsDirty();
        for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
            Rectangle cellBounds = this.grid.getCellBounds(i);
            if (cellBounds == null) continue;
            this.grid.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int ancestor = this.grid.getSelectionModel().getAnchorSelectionIndex();
        int lead = this.grid.getSelectionModel().getLeadSelectionIndex();
        if (e.getKeyCode() == 65 && this.isMenuShortcutKeyDown(e)) {
            this.grid.getSelectionModel().addSelectionInterval(0, this.grid.getModel().getSize() - 1);
        }
        if (e.getKeyCode() == 37) {
            int nextIndex;
            if (e.isShiftDown()) {
                if (!ListSelectionUtilities.isBetweenOrEqualsLeadAndAncestor(this.grid.getSelectionModel(), nextIndex) && nextIndex >= 0) {
                    for (nextIndex = this.grid.getSelectionModel().getLeadSelectionIndex() - 1; this.grid.getSelectionModel().isSelectedIndex(nextIndex) && nextIndex > 0; --nextIndex) {
                    }
                    this.grid.getSelectionModel().addSelectionInterval(lead, nextIndex);
                } else if (nextIndex >= 0) {
                    this.grid.getSelectionModel().removeSelectionInterval(lead, lead);
                    this.grid.getSelectionModel().setAnchorSelectionIndex(ancestor);
                    this.grid.getSelectionModel().setLeadSelectionIndex(nextIndex);
                }
            } else if (nextIndex >= 0) {
                this.grid.setSelectedIndex(nextIndex);
            }
        } else if (e.getKeyCode() == 39) {
            int nextIndex;
            if (e.isShiftDown()) {
                if (!ListSelectionUtilities.isBetweenOrEqualsLeadAndAncestor(this.grid.getSelectionModel(), nextIndex) && nextIndex < this.grid.getModel().getSize()) {
                    for (nextIndex = this.grid.getSelectionModel().getLeadSelectionIndex() + 1; this.grid.getSelectionModel().isSelectedIndex(nextIndex) && nextIndex < this.grid.getModel().getSize() - 1; ++nextIndex) {
                    }
                    this.grid.getSelectionModel().addSelectionInterval(lead, nextIndex);
                } else if (nextIndex < this.grid.getModel().getSize()) {
                    this.grid.getSelectionModel().removeSelectionInterval(lead, lead);
                    this.grid.getSelectionModel().setAnchorSelectionIndex(ancestor);
                    this.grid.getSelectionModel().setLeadSelectionIndex(nextIndex);
                }
            } else if (nextIndex < this.grid.getModel().getSize()) {
                this.grid.setSelectedIndex(nextIndex);
            }
        } else if (e.getKeyCode() == 40) {
            int selectedIndex = this.grid.getSelectionModel().getLeadSelectionIndex();
            int row = this.grid.getRowForIndex(selectedIndex);
            int column = this.grid.getColumnForIndex(selectedIndex);
            int nextIndex = this.grid.getIndexAt(row + 1, column);
            if (e.isShiftDown()) {
                this.grid.getSelectionModel().addSelectionInterval(this.grid.getSelectionModel().getLeadSelectionIndex(), nextIndex);
            } else {
                this.grid.setSelectedIndex(Math.min(this.grid.getModel().getSize() - 1, nextIndex));
            }
        } else if (e.getKeyCode() == 38) {
            int selectedIndex = this.grid.getSelectionModel().getLeadSelectionIndex();
            int row = this.grid.getRowForIndex(selectedIndex);
            int column = this.grid.getColumnForIndex(selectedIndex);
            int nextIndex = this.grid.getIndexAt(row - 1, column);
            if (e.isShiftDown()) {
                this.grid.getSelectionModel().addSelectionInterval(this.grid.getSelectionModel().getLeadSelectionIndex(), nextIndex);
            } else {
                this.grid.setSelectedIndex(Math.max(0, nextIndex));
            }
        }
        ListSelectionUtilities.refreshAnchorAndLead(this.grid.getSelectionModel(), this.grid.getModel().getSize() - 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            int index = this.grid.getCellAt(e.getPoint());
            if (index >= 0) {
                this.grid.requestFocus();
            }
            if (this.isMenuShortcutKeyDown(e)) {
                if (this.grid.getSelectionModel().isSelectedIndex(index)) {
                    this.grid.getSelectionModel().removeSelectionInterval(index, index);
                } else {
                    this.grid.getSelectionModel().addSelectionInterval(index, index);
                }
            } else if (e.isShiftDown()) {
                int ancestor = this.grid.getSelectionModel().getAnchorSelectionIndex();
                int lead = this.grid.getSelectionModel().getLeadSelectionIndex();
                if (ListSelectionUtilities.isBetweenOrEqualsLeadAndAncestor(this.grid.getSelectionModel(), index)) {
                    this.grid.getSelectionModel().removeSelectionInterval(lead, index);
                    this.grid.getSelectionModel().addSelectionInterval(index, index);
                    this.grid.getSelectionModel().setLeadSelectionIndex(index);
                } else if (!ListSelectionUtilities.isOnSameSideFromAncestorAsLead(this.grid.getSelectionModel(), index)) {
                    this.grid.getSelectionModel().removeSelectionInterval(ancestor, lead);
                    this.grid.getSelectionModel().addSelectionInterval(ancestor, index);
                } else {
                    this.grid.getSelectionModel().addSelectionInterval(lead, index);
                }
                this.grid.getSelectionModel().setAnchorSelectionIndex(ancestor);
            } else {
                this.grid.setSelectedIndex(index);
            }
        }
        ListSelectionUtilities.refreshAnchorAndLead(this.grid.getSelectionModel(), this.grid.getModel().getSize() - 1);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.grid.getUI().markCellBoundsAsDirty();
    }

    public boolean isMenuShortcutKeyDown(InputEvent event) {
        return (event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.grid.getUI().markCellBoundsAsDirty();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.grid.getUI().markCellBoundsAsDirty();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.grid.getUI().markCellBoundsAsDirty();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.grid.getUI().markCellBoundsAsDirty();
    }
}

