/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.jgrid.ui;

import com.guigarage.jgrid.JGrid;
import com.guigarage.jgrid.ui.BasicGridUIHandler;
import com.guigarage.jgrid.ui.GridUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;

public class BasicGridUI
extends GridUI {
    protected JGrid grid;
    private int columnCount = -1;
    private int rowCount = -1;
    private Map<Integer, Rectangle> cellBounds;
    private BasicGridUIHandler handler;
    private CellRendererPane rendererPane;
    private boolean dirtyCellBounds = true;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JGrid) {
            this.grid = (JGrid)c;
        }
        this.cellBounds = new HashMap<Integer, Rectangle>();
        this.rendererPane = new CellRendererPane();
        this.grid.add(this.rendererPane);
        this.handler = new BasicGridUIHandler(this.grid);
        this.grid.addMouseListener(this.handler);
        this.grid.addComponentListener(this.handler);
        this.grid.addKeyListener(this.handler);
        this.grid.addListDataListener(this.handler);
        this.grid.addListSelectionListener(this.handler);
        this.grid.addPropertyChangeListener(this.handler);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.grid.remove(this.rendererPane);
        this.grid.removeMouseListener(this.handler);
        this.grid.removeComponentListener(this.handler);
        this.grid.removeKeyListener(this.handler);
        this.grid.removeListDataListener(this.handler);
        this.grid.removeListSelectionListener(this.handler);
        this.grid.removePropertyChangeListener(this.handler);
        this.cellBounds.clear();
        this.handler = null;
        this.rendererPane = null;
        this.cellBounds = null;
        this.grid = null;
    }

    @Override
    public int getCellAt(Point point) {
        this.maybeUpdateCellBounds();
        for (Map.Entry<Integer, Rectangle> entry : this.cellBounds.entrySet()) {
            if (!entry.getValue().contains(point)) continue;
            return entry.getKey();
        }
        return -1;
    }

    protected boolean isDebugMode() {
        return "true".equals(System.getProperty("jgrid.debug", "false"));
    }

    private int adjustIndex(int index, JGrid grid) {
        return index < grid.getModel().getSize() ? index : -1;
    }

    protected int getPreferredHeightForWidth(int width) {
        int cellsInRow = 0;
        int aktWidth = width;
        int widthOneCell = this.grid.getHorizonztalMargin() + this.grid.getHorizonztalMargin() + this.grid.getFixedCellDimension();
        if (aktWidth > widthOneCell) {
            while (aktWidth > widthOneCell) {
                aktWidth -= widthOneCell;
                ++cellsInRow;
            }
        } else {
            cellsInRow = 1;
        }
        int rows = this.grid.getModel().getSize() / cellsInRow;
        if (this.grid.getModel().getSize() % cellsInRow > 0) {
            ++rows;
        }
        int heightOneCell = this.grid.getVerticalMargin() + this.grid.getVerticalMargin() + this.grid.getFixedCellDimension();
        return rows * heightOneCell;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int widthOneCell = this.grid.getHorizonztalMargin() + this.grid.getHorizonztalMargin() + this.grid.getFixedCellDimension();
        int width = Math.max(c.getWidth(), widthOneCell);
        int height = this.getPreferredHeightForWidth(width);
        if (this.grid.getInsets() != null) {
            width = this.grid.getInsets().left + width + this.grid.getInsets().right;
            height = this.grid.getInsets().top + height + this.grid.getInsets().bottom;
        }
        return new Dimension(width, height);
    }

    private int calcStartX() {
        int aktWidth;
        int widthOneCell = this.grid.getHorizonztalMargin() + this.grid.getHorizonztalMargin() + this.grid.getFixedCellDimension();
        int startX = 0;
        if (this.grid.getHorizontalAlignment() == 0) {
            if (aktWidth > widthOneCell) {
                for (aktWidth = this.grid.getWidth(); aktWidth > widthOneCell; aktWidth -= widthOneCell) {
                }
                startX = aktWidth / 2;
            }
        } else if (this.grid.getHorizontalAlignment() == 4) {
            while (aktWidth > widthOneCell) {
                startX = aktWidth -= widthOneCell;
            }
        }
        return startX;
    }

    private void maybeUpdateCellBounds() {
        if (this.dirtyCellBounds) {
            this.updateCellBounds();
            this.grid.revalidate();
        }
    }

    private void updateCellBounds() {
        this.cellBounds.clear();
        int x = 0;
        int y = this.grid.getVerticalMargin() + this.grid.getInsets().top;
        int row = 0;
        int indexInRow = 0;
        int startX = this.calcStartX();
        x = startX + this.grid.getInsets().left;
        for (int i = 0; i < this.grid.getModel().getSize(); ++i) {
            if (x + this.grid.getHorizonztalMargin() + this.grid.getHorizonztalMargin() + this.grid.getFixedCellDimension() > this.grid.getWidth() && indexInRow > 0) {
                this.columnCount = indexInRow;
                ++row;
                indexInRow = 0;
                x = startX;
                y = y + this.grid.getVerticalMargin() + this.grid.getVerticalMargin() + this.grid.getFixedCellDimension();
            }
            ++indexInRow;
            Rectangle r = new Rectangle(x += this.grid.getHorizonztalMargin(), y, this.grid.getFixedCellDimension(), this.grid.getFixedCellDimension());
            x = x + this.grid.getHorizonztalMargin() + this.grid.getFixedCellDimension();
            this.cellBounds.put(i, r);
        }
        this.rowCount = row + 1;
        this.dirtyCellBounds = false;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.maybeUpdateCellBounds();
        for (int i = 0; i < this.grid.getModel().getSize(); ++i) {
            int leadIndex = this.adjustIndex(this.grid.getLeadSelectionIndex(), this.grid);
            if (!g.getClipBounds().intersects(this.cellBounds.get(i))) continue;
            this.paintCell(g, c, i, this.cellBounds.get(i), leadIndex);
            this.paintCellBorder(g, c, i, this.cellBounds.get(i), leadIndex);
        }
        this.rendererPane.removeAll();
    }

    protected void paintCellBorder(Graphics g, JComponent c, int index, Rectangle bounds, int leadIndex) {
    }

    protected void paintCell(Graphics g, JComponent c, int index, Rectangle bounds, int leadIndex) {
        boolean cellHasFocus = this.grid.hasFocus() && index == leadIndex;
        boolean isSelected = this.grid.getSelectionModel().isSelectedIndex(index);
        Object value = this.grid.getModel().getElementAt(index);
        Component rendererComponent = this.grid.getCellRenderer(index).getGridCellRendererComponent(this.grid, value, index, isSelected, cellHasFocus);
        this.rendererPane.paintComponent(g, rendererComponent, this.grid, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    @Override
    public Rectangle getCellBounds(int index) {
        this.maybeUpdateCellBounds();
        return this.cellBounds.get(index);
    }

    @Override
    public int getColumnCount() {
        this.maybeUpdateCellBounds();
        return this.columnCount;
    }

    @Override
    public int getIndexAt(int row, int column) {
        if (row < 0 || column < 0) {
            return -1;
        }
        int index = 0;
        if (row > 0) {
            index = row * this.getColumnCount();
        }
        return index + column;
    }

    @Override
    public int getRowCount() {
        this.maybeUpdateCellBounds();
        return this.rowCount;
    }

    @Override
    public int getRowForIndex(int selectedIndex) {
        this.maybeUpdateCellBounds();
        return selectedIndex / this.columnCount;
    }

    @Override
    public int getColumnForIndex(int selectedIndex) {
        int row = this.getRowForIndex(selectedIndex);
        if (row == 0) {
            return selectedIndex;
        }
        int prev = row * this.getColumnCount();
        int index = selectedIndex - prev;
        return index;
    }

    @Override
    public void markCellBoundsAsDirty() {
        this.dirtyCellBounds = true;
    }

    @Override
    public int[] getCellsIntersectedBy(Rectangle rect) {
        TreeSet<Integer> intersectSet = new TreeSet<Integer>();
        for (Map.Entry<Integer, Rectangle> nextCellBounds : this.cellBounds.entrySet()) {
            if (!nextCellBounds.getValue().intersects(rect)) continue;
            intersectSet.add(nextCellBounds.getKey());
        }
        int[] returnArray = new int[intersectSet.size()];
        int i = 0;
        Iterator i$ = intersectSet.iterator();
        while (i$.hasNext()) {
            int nextInt = (Integer)i$.next();
            returnArray[i++] = nextInt;
        }
        return returnArray;
    }
}

