/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.jgrid.renderer;

import com.guigarage.jgrid.renderer.DefaultGridCellRenderer;
import com.guigarage.jgrid.renderer.GridCellRenderer;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class GridCellRendererManager {
    private GridCellRenderer defaultRenderer;
    private Map<Class<?>, GridCellRenderer> rendererMapping = new HashMap();

    public GridCellRendererManager() {
        this.defaultRenderer = new DefaultGridCellRenderer();
    }

    public void addRendererMapping(Class<?> cls, GridCellRenderer renderer) {
        this.rendererMapping.put(cls, renderer);
    }

    public void removeRendererMapping(Class<?> cls) {
        this.rendererMapping.remove(cls);
    }

    public void setDefaultRenderer(GridCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }

    public GridCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public void updateRendererUI() {
        for (GridCellRenderer renderer : this.rendererMapping.values()) {
            this.updateRendererTreeUI(renderer);
        }
        GridCellRenderer renderer = this.getDefaultRenderer();
        this.updateRendererTreeUI(renderer);
    }

    private void updateRendererTreeUI(GridCellRenderer renderer) {
        if (renderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
        }
    }

    public GridCellRenderer getRendererForClass(Class<?> cls) {
        GridCellRenderer ret = this.defaultRenderer;
        if (this.rendererMapping.containsKey(cls) && this.rendererMapping.get(cls) != null) {
            ret = this.rendererMapping.get(cls);
        }
        return ret;
    }
}

