/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.jgrid;

import com.guigarage.jgrid.eventproxies.ListDataProxy;
import com.guigarage.jgrid.eventproxies.ListSelectionProxy;
import com.guigarage.jgrid.renderer.GridCellRenderer;
import com.guigarage.jgrid.renderer.GridCellRendererManager;
import com.guigarage.jgrid.ui.BasicGridUI;
import com.guigarage.jgrid.ui.GridUI;
import com.guigarage.jgrid.ui.MacOsGridUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;

public class JGrid
extends JComponent
implements Scrollable,
SwingConstants {
    private static final long serialVersionUID = 1L;
    private ListSelectionModel selectionModel;
    private ListModel model;
    private GridCellRendererManager cellRendererManager;
    private int fixedCellDimension = 128;
    private int horizonztalMargin = 16;
    private int verticalMargin = 16;
    private Color selectionForeground;
    private Color selectionBorderColor;
    private Color selectionBackground;
    private Color cellBackground;
    private int horizontalAlignment = 0;
    private ListSelectionProxy selectionProxy = new ListSelectionProxy();
    private ListDataProxy dataProxy = new ListDataProxy();
    private static final String uiClassID = "GridUI";

    public JGrid() {
        this(new DefaultListModel());
    }

    public JGrid(ListModel model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setSelectionModel(this.createDefaultSelectionModel());
        this.setModel(model);
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setCellRendererManager(new GridCellRendererManager());
        this.setUI(new MacOsGridUI());
        this.updateUI();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.selectionProxy.addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.selectionProxy.removeListSelectionListener(l);
    }

    public void addListDataListener(ListDataListener l) {
        this.dataProxy.addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.dataProxy.addListDataListener(l);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException("selectionModel must be non null");
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this.selectionProxy);
        }
        this.selectionModel = selectionModel;
        this.selectionModel.addListSelectionListener(this.selectionProxy);
    }

    public void setCellRendererManager(GridCellRendererManager cellRendererManager) throws IllegalArgumentException {
        if (cellRendererManager == null) {
            throw new IllegalArgumentException("cellRendererManager must be non null");
        }
        GridCellRendererManager oldManager = this.cellRendererManager;
        this.cellRendererManager = cellRendererManager;
        cellRendererManager.updateRendererUI();
        this.firePropertyChange("cellRendererManager", oldManager, this.cellRendererManager);
        this.revalidateAndRepaint();
    }

    public GridCellRendererManager getCellRendererManager() {
        return this.cellRendererManager;
    }

    public void setModel(ListModel model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeListDataListener(this.dataProxy);
        }
        this.model = model;
        this.model.addListDataListener(this.dataProxy);
        this.firePropertyChange("model", oldModel, this.model);
        this.selectionModel.clearSelection();
    }

    protected void revalidateAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public ListModel getModel() {
        return this.model;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getSelectedIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    @Override
    public GridUI getUI() {
        return (GridUI)this.ui;
    }

    @Override
    public void updateUI() {
        this.cellRendererManager.updateRendererUI();
    }

    public void setFixedCellDimension(int dimension) {
        int oldValue = this.fixedCellDimension;
        this.fixedCellDimension = dimension;
        this.firePropertyChange("fixedCellDimension", oldValue, this.fixedCellDimension);
        this.revalidate();
        this.repaint();
    }

    public void setVerticalMargin(int verticalMargin) {
        int oldValue = verticalMargin;
        this.verticalMargin = verticalMargin;
        this.firePropertyChange("verticalMargin", oldValue, verticalMargin);
        this.revalidate();
        this.repaint();
    }

    public void setHorizonztalMargin(int horizonztalMargin) {
        int oldValue = horizonztalMargin;
        this.horizonztalMargin = horizonztalMargin;
        this.firePropertyChange("horizonztalMargin", oldValue, horizonztalMargin);
        this.revalidate();
        this.repaint();
    }

    public int getFixedCellDimension() {
        return this.fixedCellDimension;
    }

    public int getHorizonztalMargin() {
        return this.horizonztalMargin;
    }

    public int getVerticalMargin() {
        return this.verticalMargin;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setUI(BasicGridUI ui) {
        super.setUI(ui);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getVerticalMargin() + this.getVerticalMargin() + this.getFixedCellDimension();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getVerticalMargin() + this.getVerticalMargin() + this.getFixedCellDimension();
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color selectionForeground) {
        Color oldValue = this.selectionForeground;
        this.selectionForeground = selectionForeground;
        this.firePropertyChange("selectionForeground", oldValue, selectionForeground);
        this.repaint();
    }

    public void setSelectionBorderColor(Color selectionBorderColor) {
        Color oldValue = this.selectionBorderColor;
        this.selectionBorderColor = selectionBorderColor;
        this.firePropertyChange("selectionBorderColor", oldValue, selectionBorderColor);
        this.repaint();
    }

    public Color getSelectionBorderColor() {
        return this.selectionBorderColor;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color selectionBackground) {
        Color oldValue = this.selectionBackground;
        this.selectionBackground = selectionBackground;
        this.firePropertyChange("selectionBackground", oldValue, selectionBackground);
        this.repaint();
    }

    public Color getCellBackground() {
        return this.cellBackground;
    }

    public void setCellBackground(Color cellBackground) {
        Color oldValue = this.cellBackground;
        this.cellBackground = cellBackground;
        this.firePropertyChange("cellBackground", oldValue, cellBackground);
        this.repaint();
    }

    public void setSelectedIndex(int index) {
        if (index >= this.getModel().getSize()) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(index, index);
    }

    public Rectangle getCellBounds(int index) {
        return this.getUI().getCellBounds(index);
    }

    public int getCellAt(Point point) {
        return this.getUI().getCellAt(point);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Component renderer;
        Rectangle cellBounds;
        Point p;
        int index;
        if (event != null && (index = this.getCellAt(p = event.getPoint())) >= 0 && (cellBounds = this.getCellBounds(index)) != null && cellBounds.contains(p.x, p.y) && (renderer = this.getCellRenderer(index).getGridCellRendererComponent(this, this.getModel().getElementAt(index), index, this.getSelectionModel().isSelectedIndex(index), this.hasFocus() && this.getSelectionModel().getLeadSelectionIndex() == index)) instanceof JComponent) {
            return ((JComponent)renderer).getToolTipText(new MouseEvent(renderer, event.getID(), event.getWhen(), event.getModifiers(), p.x - cellBounds.x, p.y - cellBounds.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getButton()));
        }
        return super.getToolTipText();
    }

    public GridCellRenderer getCellRenderer(int index) {
        return this.cellRendererManager.getRendererForClass(this.getModel().getElementAt(index).getClass());
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == 2 || alignment == 0 || alignment == 4 || alignment == 10 || alignment == 11) {
            if (alignment == this.horizontalAlignment) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Illegal HorizontalAlignment: " + alignment);
        }
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = alignment;
        this.firePropertyChange("horizontalAlignment", oldValue, this.horizontalAlignment);
        this.repaint();
    }

    public int getIndexAt(int row, int column) {
        return this.getUI().getIndexAt(row, column);
    }

    public int getColumnForIndex(int index) {
        return this.getUI().getColumnForIndex(index);
    }

    public int getRowForIndex(int index) {
        return this.getUI().getRowForIndex(index);
    }

    public void setDefaultRenderer(GridCellRenderer defaultRenderer) {
        this.cellRendererManager.setDefaultRenderer(defaultRenderer);
    }

    public GridCellRenderer getDefaultRenderer() {
        return this.cellRendererManager.getDefaultRenderer();
    }

    public void addRendererMapping(Class<?> cls, GridCellRenderer renderer) {
        this.cellRendererManager.addRendererMapping(cls, renderer);
    }
}

