/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import org.jfugue.ChannelPressure;
import org.jfugue.Controller;
import org.jfugue.Instrument;
import org.jfugue.JFugueException;
import org.jfugue.KeySignature;
import org.jfugue.Layer;
import org.jfugue.Measure;
import org.jfugue.MusicStringParser;
import org.jfugue.Note;
import org.jfugue.ParserListener;
import org.jfugue.Pattern;
import org.jfugue.PitchBend;
import org.jfugue.PolyphonicPressure;
import org.jfugue.Tempo;
import org.jfugue.Time;
import org.jfugue.Voice;

public class PatternTransformer
implements ParserListener {
    private Pattern returnPattern;

    protected Pattern getReturnPattern() {
        return this.returnPattern;
    }

    protected void setReturnPattern(Pattern pattern) {
        this.returnPattern = pattern;
    }

    public Pattern transform(Pattern p) {
        this.setReturnPattern(new Pattern());
        MusicStringParser parser = new MusicStringParser();
        parser.addParserListener(this);
        try {
            parser.parse(p);
        }
        catch (JFugueException e) {
            e.printStackTrace();
        }
        return this.getReturnPattern();
    }

    public void voiceEvent(Voice voice) {
        this.returnPattern.addElement(voice);
    }

    public void tempoEvent(Tempo tempo) {
        this.returnPattern.addElement(tempo);
    }

    public void instrumentEvent(Instrument instrument) {
        this.returnPattern.addElement(instrument);
    }

    public void layerEvent(Layer layer) {
        this.returnPattern.addElement(layer);
    }

    public void timeEvent(Time time) {
        this.returnPattern.addElement(time);
    }

    public void keySignatureEvent(KeySignature keySig) {
        this.returnPattern.addElement(keySig);
    }

    public void measureEvent(Measure measure) {
        this.returnPattern.addElement(measure);
    }

    public void controllerEvent(Controller controller) {
        this.returnPattern.addElement(controller);
    }

    public void channelPressureEvent(ChannelPressure channelPressure) {
        this.returnPattern.addElement(channelPressure);
    }

    public void polyphonicPressureEvent(PolyphonicPressure polyphonicPressure) {
        this.returnPattern.addElement(polyphonicPressure);
    }

    public void pitchBendEvent(PitchBend pitchBend) {
        this.returnPattern.addElement(pitchBend);
    }

    public void noteEvent(Note note) {
        this.returnPattern.addElement(note);
    }

    public void sequentialNoteEvent(Note note) {
        this.returnPattern.addElement(note);
    }

    public void parallelNoteEvent(Note note) {
        this.returnPattern.addElement(note);
    }
}

