/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.util.EventListener;
import javax.swing.event.EventListenerList;
import org.jfugue.ChannelPressure;
import org.jfugue.Controller;
import org.jfugue.Instrument;
import org.jfugue.KeySignature;
import org.jfugue.Layer;
import org.jfugue.Measure;
import org.jfugue.Note;
import org.jfugue.ParserListener;
import org.jfugue.ParserProgressListener;
import org.jfugue.PitchBend;
import org.jfugue.PolyphonicPressure;
import org.jfugue.Tempo;
import org.jfugue.Time;
import org.jfugue.Voice;

public class Parser {
    public static final int TRACING_OFF = 0;
    public static final int TRACING_ON = 1;
    private int tracing = 0;
    protected EventListenerList progressListenerList = new EventListenerList();
    protected EventListenerList listenerList = new EventListenerList();

    public void setTracing(int tracing) {
        this.tracing = tracing;
    }

    public int getTracing() {
        return this.tracing;
    }

    protected void trace(Object ... sentenceFragments) {
        if (1 == this.getTracing()) {
            StringBuilder buddy = new StringBuilder();
            int i = 0;
            while (i < sentenceFragments.length) {
                buddy.append(sentenceFragments[i]);
                ++i;
            }
            System.out.println(buddy.toString());
        }
    }

    public void addParserProgressListener(ParserProgressListener l) {
        this.progressListenerList.add(ParserProgressListener.class, l);
    }

    public void removeParserProgressListener(ParserProgressListener l) {
        this.progressListenerList.remove(ParserProgressListener.class, l);
    }

    protected void clearParserProgressListeners() {
        EventListener[] l = this.progressListenerList.getListeners(ParserProgressListener.class);
        int numListeners = l.length;
        int i = 0;
        while (i < numListeners) {
            this.progressListenerList.remove(ParserProgressListener.class, (ParserProgressListener)l[i]);
            ++i;
        }
    }

    protected void fireProgressReported(String description, long partComplete, long whole) {
        Object[] listeners = this.progressListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserProgressListener.class) {
                ((ParserProgressListener)listeners[i + 1]).progressReported(description, partComplete, whole);
            }
            i -= 2;
        }
    }

    public void addParserListener(ParserListener l) {
        this.listenerList.add(ParserListener.class, l);
    }

    public void removeParserListener(ParserListener l) {
        this.listenerList.remove(ParserListener.class, l);
    }

    protected void clearParserListeners() {
        EventListener[] l = this.listenerList.getListeners(ParserListener.class);
        int numListeners = l.length;
        int i = 0;
        while (i < numListeners) {
            this.listenerList.remove(ParserListener.class, (ParserListener)l[i]);
            ++i;
        }
    }

    protected void fireVoiceEvent(Voice event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).voiceEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireTempoEvent(Tempo event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).tempoEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireInstrumentEvent(Instrument event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).instrumentEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireLayerEvent(Layer event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).layerEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireTimeEvent(Time event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).timeEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireKeySignatureEvent(KeySignature event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).keySignatureEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireMeasureEvent(Measure event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).measureEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireControllerEvent(Controller event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).controllerEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireChannelPressureEvent(ChannelPressure event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).channelPressureEvent(event);
            }
            i -= 2;
        }
    }

    protected void firePolyphonicPressureEvent(PolyphonicPressure event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).polyphonicPressureEvent(event);
            }
            i -= 2;
        }
    }

    protected void firePitchBendEvent(PitchBend event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).pitchBendEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireNoteEvent(Note event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).noteEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireSequentialNoteEvent(Note event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).sequentialNoteEvent(event);
            }
            i -= 2;
        }
    }

    protected void fireParallelNoteEvent(Note event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ParserListener.class) {
                ((ParserListener)listeners[i + 1]).parallelNoteEvent(event);
            }
            i -= 2;
        }
    }
}

