/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.examples;

import com.sun.media.sound.AudioSynthesizer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.jfugue.JFugueException;
import org.jfugue.Pattern;
import org.jfugue.Player;

public class Midi2WavRenderer {
    private Synthesizer synth = MidiSystem.getSynthesizer();

    private Soundbank loadSoundbank(File soundbankFile) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        Soundbank soundbank = MidiSystem.getSoundbank(soundbankFile);
        if (!this.synth.isSoundbankSupported(soundbank)) {
            throw new JFugueException("Soundbank not supported by synthesizer");
        }
        return soundbank;
    }

    public void createWavFile(File soundbankFile, int[] patches, Pattern pattern, File outputFile) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        Sequencer sequencer = Player.getSequencerConnectedToSynthesizer((Synthesizer)this.synth);
        Player player = new Player(sequencer);
        Sequence sequence = player.getSequence(pattern);
        this.createWavFile(soundbankFile, patches, sequence, outputFile);
    }

    public void createWavFile(File soundbankFile, int[] patches, Sequence sequence, File outputFile) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        Soundbank soundbank = this.loadSoundbank(soundbankFile);
        this.synth.open();
        this.synth.unloadAllInstruments(soundbank);
        for (int patch : patches) {
            this.synth.loadInstrument(soundbank.getInstrument(new Patch(0, patch)));
        }
        this.createWavFile(sequence, outputFile);
    }

    public void createWavFile(Pattern pattern, File outputFile) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        Sequencer sequencer = Player.getSequencerConnectedToSynthesizer((Synthesizer)this.synth);
        Player player = new Player(sequencer);
        Sequence sequence = player.getSequence(pattern);
        this.createWavFile(sequence, outputFile);
    }

    public void createWavFile(Sequence sequence, File outputFile) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        AudioSynthesizer synth = this.findAudioSynthesizer();
        if (synth == null) {
            throw new JFugueException("No AudioSynthesizer was found!");
        }
        AudioFormat format = new AudioFormat(96000.0f, 24, 2, true, false);
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("interpolation", "sinc");
        p.put("max polyphony", "1024");
        AudioInputStream stream = synth.openStream(format, p);
        double total = this.send(sequence, synth.getReceiver());
        long len = (long)((double)stream.getFormat().getFrameRate() * (total + 4.0));
        stream = new AudioInputStream(stream, stream.getFormat(), len);
        AudioSystem.write(stream, AudioFileFormat.Type.WAVE, outputFile);
        this.synth.close();
    }

    private AudioSynthesizer findAudioSynthesizer() throws MidiUnavailableException {
        Synthesizer synth = MidiSystem.getSynthesizer();
        if (synth instanceof AudioSynthesizer) {
            return (AudioSynthesizer)synth;
        }
        MidiDevice.Info[] midiDeviceInfo = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < midiDeviceInfo.length; ++i) {
            MidiDevice dev = MidiSystem.getMidiDevice(midiDeviceInfo[i]);
            if (!(dev instanceof AudioSynthesizer)) continue;
            return (AudioSynthesizer)dev;
        }
        return null;
    }

    private double send(Sequence seq, Receiver recv) {
        float divtype = seq.getDivisionType();
        assert (seq.getDivisionType() == 0.0f);
        Track[] tracks = seq.getTracks();
        int[] trackspos = new int[tracks.length];
        int mpq = 500000;
        int seqres = seq.getResolution();
        long lasttick = 0L;
        long curtime = 0L;
        while (true) {
            MidiEvent selevent = null;
            int seltrack = -1;
            for (int i = 0; i < tracks.length; ++i) {
                int trackpos = trackspos[i];
                Track track = tracks[i];
                if (trackpos >= track.size()) continue;
                MidiEvent event = track.get(trackpos);
                if (selevent != null && event.getTick() >= selevent.getTick()) continue;
                selevent = event;
                seltrack = i;
            }
            if (seltrack == -1) break;
            int n = seltrack;
            trackspos[n] = trackspos[n] + 1;
            long tick = selevent.getTick();
            curtime = divtype == 0.0f ? (curtime += (tick - lasttick) * (long)mpq / (long)seqres) : (long)((double)tick * 1000000.0 * (double)divtype / (double)seqres);
            lasttick = tick;
            MidiMessage msg = selevent.getMessage();
            if (msg instanceof MetaMessage) {
                if (divtype != 0.0f || ((MetaMessage)msg).getType() != 81) continue;
                byte[] data = ((MetaMessage)msg).getData();
                mpq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                continue;
            }
            if (recv == null) continue;
            recv.send(msg, curtime);
        }
        return (double)curtime / 1000000.0;
    }
}

