/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose.core;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.jexplose.core.ExploseLayout;
import org.jdesktop.swingx.jexplose.core.Painter;
import org.jdesktop.swingx.jexplose.core.Thumbnail;

public class LayoutSelectionPainter
implements Painter {
    private static final int PADDING = 5;
    private ExploseLayout _layout;

    public LayoutSelectionPainter(ExploseLayout exploseLayout) {
        this._layout = exploseLayout;
    }

    public void prepare(JComponent jComponent) {
    }

    public void paint(Graphics graphics) {
        Thumbnail thumbnail = this._layout.getSelected();
        if (thumbnail != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = this._layout.getScale();
            Rectangle rectangle = new Rectangle(thumbnail);
            rectangle.x = (int)((double)(rectangle.x + this._layout.getTotalOffset().x) * d);
            rectangle.y = (int)((double)(rectangle.y + this._layout.getTotalOffset().y) * d);
            rectangle.width = (int)((double)rectangle.width * d);
            rectangle.height = (int)((double)rectangle.height * d);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
            graphics2D.setPaint(Color.black);
            int n = SwingUtilities.computeStringWidth(graphics2D.getFontMetrics(), thumbnail.getIFrame().getTitle());
            int n2 = rectangle.x + rectangle.width / 2 - n / 2;
            int n3 = rectangle.y + rectangle.height / 2 + graphics2D.getFont().getSize() / 2;
            graphics2D.fillRoundRect(n2 - 5, n3 - graphics2D.getFont().getSize() - 5, n + 10, graphics2D.getFont().getSize() + 10, 4, 4);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(Color.white);
            graphics2D.drawString(thumbnail.getIFrame().getTitle(), n2, n3);
        }
    }

    public void dispose() {
    }
}

