/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.jexplose.core.Painter;
import org.jdesktop.swingx.jexplose.core.WaitPainter;

public class EffectPanel
extends JComponent {
    private JComponent _comp;
    private Component _glassPaneBackup;
    private JRootPane _rootPaneBackup;
    private List _painters = new ArrayList();
    private boolean _paintBackgroundWhenNotOpaque = false;
    private Thread _thread;

    public void install(JComponent jComponent) {
        this.setBackground(jComponent.getBackground());
        this._comp = jComponent;
        this._rootPaneBackup = jComponent.getRootPane();
        this._glassPaneBackup = this._rootPaneBackup.getGlassPane();
        this._rootPaneBackup.setGlassPane(this);
        this.setVisible(true);
        this.requestFocus();
        this._thread = new Thread(){

            public void run() {
                while (true) {
                    EffectPanel.this.repaint();
                    try {
                        1.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
        this._thread.start();
    }

    public void dispose() {
        this._thread.interrupt();
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    boolean bl = EffectPanel.this._glassPaneBackup.isVisible();
                    EffectPanel.this._rootPaneBackup.setGlassPane(EffectPanel.this._glassPaneBackup);
                    EffectPanel.this.setVisible(false);
                    EffectPanel.this._glassPaneBackup.setVisible(bl);
                    EffectPanel.this._rootPaneBackup.repaint();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Serializable serializable;
        if (this.isOpaque() || this._paintBackgroundWhenNotOpaque) {
            serializable = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor((Color)serializable);
        }
        Object object = this;
        synchronized (object) {
            serializable = new ArrayList(this._painters);
        }
        object = serializable.listIterator();
        while (object.hasNext()) {
            Painter painter = (Painter)object.next();
            painter.paint(graphics.create());
        }
    }

    public synchronized void addPainter(Painter painter) {
        painter.prepare(this);
        this._painters.add(painter);
        this.repaint();
    }

    public synchronized void removePainter(Painter painter) {
        if (this._painters.remove(painter)) {
            painter.dispose();
        }
        this.repaint();
    }

    public synchronized void setPainter(Painter painter) {
        this.removeAllPainters();
        if (painter != null) {
            painter.prepare(this);
            this._painters.add(painter);
        }
    }

    public void removeAllPainters() {
        ListIterator listIterator = this._painters.listIterator();
        while (listIterator.hasNext()) {
            Painter painter = (Painter)listIterator.next();
            painter.dispose();
            listIterator.remove();
        }
    }

    public void bePatient() {
        this.setPainter(new WaitPainter());
    }
}

