/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose.core;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.swingx.jexplose.core.Painter;

public class WaitPainter
implements Painter {
    private int _nbTrace = 4;
    private int _nbStep = 10;
    private JComponent _comp;
    int _step = 0;
    final Timer _timer = new Timer(40, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ++WaitPainter.this._step;
            WaitPainter.this._step %= WaitPainter.this._nbStep;
            WaitPainter.this._comp.repaint();
        }
    });

    public void prepare(JComponent jComponent) {
        this._comp = jComponent;
        this._timer.start();
    }

    public void dispose() {
        this._timer.stop();
    }

    public void paint(Graphics graphics) {
        for (int i = 0; i < this._nbTrace; ++i) {
            this.drawRect((Graphics2D)graphics, (this._step - i) % this._nbStep, new Color(255 - i * (200 / this._nbTrace)));
        }
    }

    private void drawRect(Graphics2D graphics2D, int n, Color color) {
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(this._comp.getWidth() / 2, this._comp.getHeight() / 2);
        graphics2D.rotate(Math.PI * 2 / (double)this._nbStep * (double)n);
        graphics2D.translate(0, -100);
        graphics2D.setColor(color);
        graphics2D.fillRect(-5, -15, 10, 30);
        graphics2D.setTransform(affineTransform);
    }
}

