/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose.core;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.RepaintManager;
import org.jdesktop.swingx.jexplose.core.ExploseLayout;
import org.jdesktop.swingx.jexplose.core.Painter;
import org.jdesktop.swingx.jexplose.core.Thumbnail;

public class LayoutStandardPainter
implements Painter {
    private ExploseLayout _layout;
    private double _scale;
    private Dimension _dim;
    private boolean _prepared = false;
    private JDesktopPane _desktop;
    private static BufferedImage _buffer;

    public LayoutStandardPainter(JDesktopPane jDesktopPane, ExploseLayout exploseLayout, double d) {
        this._desktop = jDesktopPane;
        this._layout = exploseLayout;
        this._scale = d;
        this._dim = new Dimension(this._layout.getFinalDimension());
        this._dim.width = (int)((double)this._dim.width * this._scale);
        this._dim.height = (int)((double)this._dim.height * this._scale);
    }

    public void prepare(JComponent jComponent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        long l = System.currentTimeMillis();
        Graphics2D graphics2D = (Graphics2D)graphics;
        List list = this._layout.getThumbs();
        if (this._dim.width > 0 && this._dim.height > 0) {
            ExploseLayout exploseLayout = this._layout;
            synchronized (exploseLayout) {
                double d = this._layout.getScale();
                graphics2D.scale(d, d);
                RepaintManager repaintManager = RepaintManager.currentManager(null);
                boolean bl = repaintManager.isDoubleBufferingEnabled();
                repaintManager.setDoubleBufferingEnabled(false);
                for (int i = list.size() - 1; i >= 0; --i) {
                    Thumbnail thumbnail = (Thumbnail)list.get(i);
                    if (thumbnail == this._layout.getSelected()) continue;
                    Thumbnail thumbnail2 = thumbnail;
                    synchronized (thumbnail2) {
                        graphics.translate(thumbnail.x + this._layout.getTotalOffset().x, thumbnail.y + this._layout.getTotalOffset().y);
                        thumbnail.getIFrame().paint(graphics);
                        graphics.translate(-(thumbnail.x + this._layout.getTotalOffset().x), -(thumbnail.y + this._layout.getTotalOffset().y));
                        continue;
                    }
                }
                Thumbnail thumbnail = this._layout.getSelected();
                if (thumbnail != null) {
                    graphics.translate(thumbnail.x + this._layout.getTotalOffset().x, thumbnail.y + this._layout.getTotalOffset().y);
                    thumbnail.getIFrame().paint(graphics);
                    graphics.translate(-(thumbnail.x + this._layout.getTotalOffset().x), -(thumbnail.y + this._layout.getTotalOffset().y));
                }
                repaintManager.setDoubleBufferingEnabled(bl);
                graphics.dispose();
            }
        }
        long l2 = System.currentTimeMillis() - l;
    }

    public void dispose() {
    }
}

