/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.jdesktop.swingx.jexplose.core.Thumbnail;

public class ExploseLayout {
    private Dimension _dim = new Dimension(0, 0);
    private List _thumbs = new ArrayList();
    private double _scale;
    private Point _desktopOffset = new Point();
    private Point _centerOffset = new Point();
    private Point _totalOffset = new Point();
    private Thumbnail _selected;
    private boolean _isFinal;
    public boolean moved;
    private Dimension _finalDim = new Dimension(0, 0);
    private JDesktopPane _desktop;

    public ExploseLayout(JDesktopPane jDesktopPane) {
        this._desktop = jDesktopPane;
    }

    public Thumbnail place(JInternalFrame jInternalFrame, int n, int n2) {
        Thumbnail thumbnail = new Thumbnail(jInternalFrame, n, n2);
        this._finalDim.width = Math.max(this._finalDim.width, n + thumbnail.width);
        this._finalDim.height = Math.max(this._finalDim.height, n2 + thumbnail.height);
        this._thumbs.add(thumbnail);
        return thumbnail;
    }

    public void computeDimension() {
        this._dim.width = 0;
        this._dim.height = 0;
        ListIterator listIterator = this._thumbs.listIterator();
        while (listIterator.hasNext()) {
            Thumbnail thumbnail = (Thumbnail)listIterator.next();
            this._dim.width = Math.max(this._dim.width, thumbnail.x + thumbnail.width);
            this._dim.height = Math.max(this._dim.height, thumbnail.y + thumbnail.height);
        }
    }

    public Thumbnail getThumbnailAt(Point point) {
        int n = (int)((double)point.x / this._scale - (double)this._totalOffset.x);
        int n2 = (int)((double)point.y / this._scale - (double)this._totalOffset.y);
        ListIterator listIterator = this._thumbs.listIterator();
        while (listIterator.hasNext()) {
            Thumbnail thumbnail = (Thumbnail)listIterator.next();
            if (!thumbnail.contains(n, n2)) continue;
            return thumbnail;
        }
        return null;
    }

    public void dispose() {
        this._thumbs.clear();
    }

    public void updateScale() {
        Dimension dimension = this._desktop.getSize();
        double d = this.computeScale(this._dim, dimension);
        this.updateScale(d, this.computeOffset(dimension, d, this._dim));
    }

    public Point getFinalOffset() {
        return this.computeOffset(this._desktop.getSize(), this.getFinalScale(), this.getFinalDimension());
    }

    private Point computeOffset(Dimension dimension, double d, Dimension dimension2) {
        return new Point((int)((double)dimension.width / d - (double)dimension2.width) / 2, (int)((double)dimension.height / d - (double)dimension2.height) / 2);
    }

    public void updateScale(double d, Point point) {
        this._scale = d;
        this._desktopOffset.x = 0;
        this._desktopOffset.y = 0;
        for (Container container = this._desktop; container != this._desktop.getRootPane(); container = container.getParent()) {
            this._desktopOffset.x += ((Component)container).getX();
            this._desktopOffset.y += ((Component)container).getY();
        }
        this._desktopOffset.x = (int)((double)this._desktopOffset.x / this._scale);
        this._desktopOffset.y = (int)((double)this._desktopOffset.y / this._scale);
        this._centerOffset.x = point.x;
        this._centerOffset.y = point.y;
        this._totalOffset.x = this._desktopOffset.x + this._centerOffset.x;
        this._totalOffset.y = this._desktopOffset.y + this._centerOffset.y;
    }

    public double computeScale(Dimension dimension, Dimension dimension2) {
        return Math.min(Math.min((double)(dimension2.width - 24) / (double)dimension.width, (double)(dimension2.height - 24) / (double)dimension.height), 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFinal(boolean bl) {
        if (bl) {
            ListIterator listIterator = this._thumbs.listIterator();
            while (listIterator.hasNext()) {
                Thumbnail thumbnail;
                Thumbnail thumbnail2 = thumbnail = (Thumbnail)listIterator.next();
                synchronized (thumbnail2) {
                    thumbnail.setLocation(thumbnail.getFinalLocation());
                }
            }
            this.moved = true;
        }
        this._isFinal = bl;
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public boolean select(Thumbnail thumbnail) {
        boolean bl = this._selected != thumbnail;
        this._selected = thumbnail;
        return bl;
    }

    public Dimension getDimension() {
        return this._dim;
    }

    public double getScale() {
        return this._scale;
    }

    public List getThumbs() {
        return this._thumbs;
    }

    public Thumbnail getSelected() {
        return this._selected;
    }

    public Point getCenterOffset() {
        return this._centerOffset;
    }

    public Point getDesktopOffset() {
        return this._desktopOffset;
    }

    public Point getTotalOffset() {
        return this._totalOffset;
    }

    public Dimension getFinalDimension() {
        return this._finalDim;
    }

    public double getFinalScale() {
        return this.computeScale(this._finalDim, this._desktop.getSize());
    }
}

