/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose.core;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jdesktop.swingx.jexplose.core.ExploseLayout;
import org.jdesktop.swingx.jexplose.core.Painter;

public class BackgroundPainter
implements Painter {
    private static final float ALPHA = 0.25f;
    private static final float ALPHA_STEP = 0.025f;
    private static final double FITTING = 0.8;
    private static ImageIcon _logo;
    private static int _width;
    private static int _height;
    private static URL _backgroundURL;
    private ExploseLayout _layout;
    private JComponent _comp;
    private int _x;
    private int _y;
    private BufferedImage _buffer;
    private double _scale;
    private transient boolean _bufferReady;
    private transient float _alpha;
    private transient boolean _disposed = false;

    public BackgroundPainter(ExploseLayout exploseLayout) {
        URL uRL;
        this._layout = exploseLayout;
        if ((_logo == null || _width == 0 || _height == 0) && (uRL = BackgroundPainter.getBackgroundURL()) != null) {
            _logo = new ImageIcon(uRL);
            _width = _logo.getIconWidth();
            _height = _logo.getIconHeight();
        }
    }

    private static URL getBackgroundURL() {
        return _backgroundURL;
    }

    public void prepare(JComponent jComponent) {
        this._disposed = false;
        this._comp = jComponent;
        this._scale = Math.min((double)this._comp.getWidth() * 0.8 / (double)_width, (double)this._comp.getHeight() * 0.8 / (double)_height);
        this._x = this._comp.isOpaque() ? 0 : (int)((double)this._layout.getDesktopOffset().x * this._layout.getScale());
        this._y = this._comp.isOpaque() ? 0 : (int)((double)this._layout.getDesktopOffset().y * this._layout.getScale());
        this._x = (int)((double)this._x + ((double)this._comp.getWidth() - (double)_width * this._scale) / 2.0);
        this._y = (int)((double)this._y + ((double)this._comp.getHeight() - (double)_height * this._scale) / 2.0);
        this._bufferReady = false;
        Thread thread = new Thread(){

            public void run() {
                if (_logo != null) {
                    try {
                        1.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    if (BackgroundPainter.this._disposed) {
                        return;
                    }
                    BackgroundPainter.this._alpha = 0.0f;
                    BackgroundPainter.this._buffer = BackgroundPainter.this._comp.getGraphicsConfiguration().createCompatibleImage((int)((double)_width * BackgroundPainter.this._scale), (int)((double)_height * BackgroundPainter.this._scale), 3);
                    Graphics2D graphics2D = (Graphics2D)BackgroundPainter.this._buffer.getGraphics();
                    graphics2D.scale(BackgroundPainter.this._scale, BackgroundPainter.this._scale);
                    graphics2D.drawImage(_logo.getImage(), 0, 0, null);
                    BackgroundPainter.this._bufferReady = true;
                    while (BackgroundPainter.this._alpha < 0.25f) {
                        BackgroundPainter.this._alpha += 0.025f;
                        try {
                            1.sleep(50L);
                            if (BackgroundPainter.this._disposed) {
                                return;
                            }
                            BackgroundPainter.this._comp.repaint();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void paint(Graphics graphics) {
        if (this._bufferReady) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(AlphaComposite.getInstance(3, this._alpha));
            graphics2D.drawImage((Image)this._buffer, this._x, this._y, null);
        }
    }

    public void dispose() {
        this._disposed = true;
    }

    public static void setBackgroundURL(URL uRL) {
        _logo = null;
        _backgroundURL = uRL;
    }

    static {
        _backgroundURL = BackgroundPainter.class.getResource("logo.gif");
    }
}

