/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose.animation;

import java.awt.Point;
import java.util.List;
import java.util.ListIterator;
import org.jdesktop.swingx.jexplose.AnimationStrategy;
import org.jdesktop.swingx.jexplose.core.AnimationUpdate;
import org.jdesktop.swingx.jexplose.core.ExploseLayout;
import org.jdesktop.swingx.jexplose.core.Thumbnail;

public class StandardAnimationStrategy
implements AnimationStrategy {
    private int _nbSteps;
    private long _period;

    public StandardAnimationStrategy(int n, long l) {
        if (n < 0) {
            throw new IllegalArgumentException("negative number of steps not allowed");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("negative period not allowed");
        }
        this._nbSteps = n;
        this._period = l;
    }

    public void explose(ExploseLayout exploseLayout, AnimationUpdate animationUpdate) {
        this.anim(exploseLayout, animationUpdate, false);
    }

    public void implose(ExploseLayout exploseLayout, AnimationUpdate animationUpdate) {
        this.anim(exploseLayout, animationUpdate, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void anim(ExploseLayout exploseLayout, AnimationUpdate animationUpdate, boolean bl) {
        int n;
        double d = exploseLayout.getFinalScale();
        Point point = exploseLayout.getFinalOffset();
        double d2 = (1.0 - d) / (double)(this._nbSteps + 1);
        double d3 = (double)point.x / (double)(this._nbSteps + 1);
        double d4 = (double)point.y / (double)(this._nbSteps + 1);
        Point point2 = new Point();
        int n2 = bl ? -1 : 1;
        int n3 = n = bl ? this._nbSteps - 1 : 0;
        while (bl ? n >= 0 : n < this._nbSteps) {
            List list = exploseLayout.getThumbs();
            ExploseLayout exploseLayout2 = exploseLayout;
            synchronized (exploseLayout2) {
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    Thumbnail thumbnail;
                    Thumbnail thumbnail2 = thumbnail = (Thumbnail)listIterator.next();
                    synchronized (thumbnail2) {
                        thumbnail.x = thumbnail.getOriginalLocation().x + (thumbnail.getFinalLocation().x - thumbnail.getOriginalLocation().x) / (this._nbSteps + 1) * (n + 1);
                        thumbnail.y = thumbnail.getOriginalLocation().y + (thumbnail.getFinalLocation().y - thumbnail.getOriginalLocation().y) / (this._nbSteps + 1) * (n + 1);
                    }
                }
                exploseLayout.computeDimension();
                point2.x = (int)(d3 * (double)(n + 1));
                point2.y = (int)(d4 * (double)(n + 1));
                exploseLayout.updateScale(1.0 - d2 * (double)(n + 1), point2);
            }
            animationUpdate.step();
            if (this._period > 0L) {
                try {
                    Thread.sleep(this._period);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            n += n2;
        }
        animationUpdate.end();
    }
}

