/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import org.jdesktop.swingx.jexplose.Explosable;
import org.jdesktop.swingx.jexplose.JExplose;
import org.jdesktop.swingx.jexplose.util.JExploseKeyDispatcher;

public class JExploseUtils {
    public static Action getThunderAction(final JDesktopPane jDesktopPane) {
        AbstractAction abstractAction = new AbstractAction("JExplose"){

            public void actionPerformed(ActionEvent actionEvent) {
                JExplose.getInstance().explose(jDesktopPane);
            }
        };
        abstractAction.putValue("SmallIcon", new ImageIcon(JExploseUtils.class.getResource("icon.png")));
        return abstractAction;
    }

    public static Action getLightningAction(final Explosable explosable) {
        AbstractAction abstractAction = new AbstractAction("JExplose"){

            public void actionPerformed(ActionEvent actionEvent) {
                JExplose.getInstance().explose(explosable);
            }
        };
        abstractAction.putValue("SmallIcon", new ImageIcon(JExploseUtils.class.getResource("icon.png")));
        return abstractAction;
    }

    public static void installLightningHotKey(final Explosable explosable, final int n) {
        try {
            Class<?> clazz = Class.forName("java.awt.KeyboardFocusManager");
            JExploseKeyDispatcher.registerLightning(explosable, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent aWTEvent) {
                    if (((KeyEvent)aWTEvent).getKeyCode() == n) {
                        JExplose.getInstance().explose(explosable);
                    }
                }
            }, 8L);
        }
    }

    public static void installThunderHotKey(final JDesktopPane jDesktopPane, final int n) {
        try {
            Class<?> clazz = Class.forName("java.awt.KeyboardFocusManager");
            JExploseKeyDispatcher.registerThunder(jDesktopPane, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent aWTEvent) {
                    if (((KeyEvent)aWTEvent).getKeyCode() == n) {
                        JExplose.getInstance().explose(jDesktopPane);
                    }
                }
            }, 8L);
        }
    }
}

