/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.JDesktopPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.jexplose.AnimationStrategy;
import org.jdesktop.swingx.jexplose.Explosable;
import org.jdesktop.swingx.jexplose.LayoutExplosablePainter;
import org.jdesktop.swingx.jexplose.LayoutStrategy;
import org.jdesktop.swingx.jexplose.animation.StandardAnimationStrategy;
import org.jdesktop.swingx.jexplose.core.AnimationUpdate;
import org.jdesktop.swingx.jexplose.core.BackgroundPainter;
import org.jdesktop.swingx.jexplose.core.EffectPanel;
import org.jdesktop.swingx.jexplose.core.ExploseLayout;
import org.jdesktop.swingx.jexplose.core.LayoutSelectionPainter;
import org.jdesktop.swingx.jexplose.core.LayoutStandardPainter;
import org.jdesktop.swingx.jexplose.core.Painter;
import org.jdesktop.swingx.jexplose.core.Thumbnail;
import org.jdesktop.swingx.jexplose.layout.StandardLayoutStrategy;

public class JExplose {
    private static JExplose _instance = new JExplose(new StandardLayoutStrategy(), new StandardAnimationStrategy(7, 50L));
    private LayoutStrategy _layoutStrategy;
    private AnimationStrategy _animationStrategy;
    private EffectPanel _effectPanel;
    private ExploseLayout _layout;
    private ExplosedHandler _explosedHandler = new ExplosedHandler();
    private Explosable _explosable;
    private JDesktopPane _desktop;
    private Painter _painter;
    private Painter _selPainter;
    private static transient boolean _isExplosed = false;
    private long _start;
    private boolean _debug = false;
    private Painter _bgPainter;

    public static JExplose getInstance() {
        return _instance;
    }

    public static void setInstance(JExplose jExplose) {
        _instance = jExplose;
    }

    public JExplose(LayoutStrategy layoutStrategy, AnimationStrategy animationStrategy) {
        this._layoutStrategy = layoutStrategy;
        this._animationStrategy = animationStrategy;
    }

    public void explose(JDesktopPane jDesktopPane) {
        this.explose(null, jDesktopPane);
    }

    public void explose(Explosable explosable) {
        this.explose(explosable, explosable.getDesktop());
    }

    public void setBackground(URL uRL) {
        BackgroundPainter.setBackgroundURL(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explose(Explosable explosable, JDesktopPane jDesktopPane) {
        if (jDesktopPane.getAllFrames().length <= 1) {
            return;
        }
        Dimension dimension = jDesktopPane.getSize();
        if (dimension.width <= 10 || dimension.height <= 10) {
            return;
        }
        this._start = System.currentTimeMillis();
        Object object = this.getClass();
        synchronized (object) {
            if (_isExplosed) {
                return;
            }
            _isExplosed = true;
        }
        this._explosable = explosable;
        this._desktop = jDesktopPane;
        _isExplosed = true;
        this._effectPanel = new EffectPanel();
        this._effectPanel.install(this._desktop);
        if (this._explosable != null) {
            this._effectPanel.setOpaque(false);
            this._effectPanel.setBackground(new Color(200, 200, 200, 50));
        } else {
            this._effectPanel.setOpaque(true);
        }
        this.msg("starting thread");
        object = new Thread(){

            public void run() {
                JExplose.this.msg("thread launched: doing layout");
                JExplose.this._layout = JExplose.this.getLayoutStrategy().layout(JExplose.this._desktop);
                JExplose.this.msg("layout done");
                if (JExplose.this._explosable == null) {
                    // empty if block
                }
                JExplose.this.msg("launching anim");
                JExplose.this.getAnimationStrategy().explose(JExplose.this._layout, new AnimationUpdate(){
                    boolean addedPainter = false;

                    public void step() {
                        JExplose.this.msg("stepping");
                        if (JExplose.this._explosable != null) {
                            JExplose.this._explosable.start();
                        }
                        ((JExplose)JExplose.this)._layout.moved = true;
                        if (!this.addedPainter) {
                            JExplose.this._effectPanel.setPainter(JExplose.this.getPainter());
                            this.addedPainter = true;
                        } else {
                            JExplose.this._effectPanel.repaint();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void end() {
                        JExplose.this.msg("reached anim end");
                        if (JExplose.this._explosable != null) {
                            JExplose.this._explosable.start();
                        }
                        JExplose.this._layout.setFinal(true);
                        JExplose.this._layout.computeDimension();
                        JExplose.this._layout.updateScale();
                        ((JExplose)JExplose.this)._layout.moved = true;
                        JExplose.this.msg("set final state: scale=" + JExplose.this._layout.getScale());
                        EffectPanel effectPanel = JExplose.this._effectPanel;
                        synchronized (effectPanel) {
                            JExplose.this._effectPanel.removeAllPainters();
                            if (JExplose.this._explosable == null) {
                                JExplose.this._effectPanel.addPainter(JExplose.this.getBackgroundPainter());
                            } else {
                                JExplose.this._explosable.addPainter(JExplose.this.getBackgroundPainter());
                            }
                            JExplose.this._effectPanel.addPainter(JExplose.this.getPainter());
                            JExplose.this._effectPanel.addPainter(JExplose.this.getSelectionPainter());
                        }
                        JExplose.this.msg("explosed !!!");
                        JExplose.this._explosedHandler.install(JExplose.this._effectPanel);
                    }
                });
            }
        };
        ((Thread)object).start();
    }

    private void msg(String string) {
        if (this._debug) {
            System.out.println(System.currentTimeMillis() + ": " + string + " (" + (System.currentTimeMillis() - this._start) + "ms)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implose(final Thumbnail thumbnail) {
        this._start = System.currentTimeMillis();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!_isExplosed) {
                throw new IllegalStateException("impossible to call implose when not explosed");
            }
        }
        new Thread(){

            public void run() {
                JExplose.this._layout.setFinal(false);
                JExplose.this._effectPanel.removePainter(JExplose.this.getSelectionPainter());
                if (JExplose.this._explosable == null) {
                    JExplose.this._effectPanel.removePainter(JExplose.this.getBackgroundPainter());
                } else {
                    JExplose.this._explosable.removePainter(JExplose.this.getBackgroundPainter());
                }
                if (thumbnail != null) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                try {
                                    thumbnail.getIFrame().toFront();
                                    thumbnail.getIFrame().setSelected(true);
                                    thumbnail.getIFrame().requestFocus();
                                }
                                catch (PropertyVetoException propertyVetoException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                JExplose.this.getAnimationStrategy().implose(JExplose.this._layout, new AnimationUpdate(){

                    public void step() {
                        ((JExplose)JExplose.this)._layout.moved = true;
                        JExplose.this._effectPanel.repaint();
                    }

                    public void end() {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Object object;
                                if (JExplose.this._explosable != null) {
                                    JExplose.this._explosable.setScale(1.0);
                                    JExplose.this._explosable.end();
                                    object = JExplose.this._layout.getThumbs().listIterator();
                                    while (object.hasNext()) {
                                        Thumbnail thumbnail = (Thumbnail)object.next();
                                        thumbnail.getIFrame().setLocation(thumbnail.getOriginalLocation());
                                        if (thumbnail == thumbnail) continue;
                                        thumbnail.restore();
                                    }
                                    JExplose.this._explosable.getDesktop().repaint();
                                } else {
                                    object = JExplose.this._layout.getThumbs().listIterator();
                                    while (object.hasNext()) {
                                        Thumbnail thumbnail = (Thumbnail)object.next();
                                        if (thumbnail == thumbnail) continue;
                                        thumbnail.restore();
                                    }
                                }
                                JExplose.this._effectPanel.dispose();
                                JExplose.this._layout.dispose();
                                JExplose.this._effectPanel = null;
                                JExplose.this._layout = null;
                                JExplose.this._explosable = null;
                                JExplose.this._painter = null;
                                JExplose.this._selPainter = null;
                                JExplose.this._bgPainter = null;
                                object = this.getClass();
                                synchronized (object) {
                                    _isExplosed = false;
                                }
                                JExplose.this._desktop.getRootPane().revalidate();
                                JExplose.this._desktop.getRootPane().repaint();
                                JExplose.this._desktop = null;
                                JExplose.this.msg("implosed !!!");
                            }
                        });
                    }
                });
            }
        }.start();
    }

    private AnimationStrategy getAnimationStrategy() {
        return this._animationStrategy;
    }

    private LayoutStrategy getLayoutStrategy() {
        return this._layoutStrategy;
    }

    private Painter getSelectionPainter() {
        if (this._selPainter == null) {
            this._selPainter = new LayoutSelectionPainter(this._layout);
        }
        return this._selPainter;
    }

    private Painter getBackgroundPainter() {
        if (this._bgPainter == null) {
            this._bgPainter = new BackgroundPainter(this._layout);
        }
        return this._bgPainter;
    }

    private Painter getPainter() {
        if (this._painter == null) {
            this._painter = this._explosable == null ? new LayoutStandardPainter(this._desktop, this._layout, this._layout.computeScale(this._layout.getFinalDimension(), this._desktop.getSize())) : new LayoutExplosablePainter(this._layout, this._explosable);
        }
        return this._painter;
    }

    private final class ExplosedHandler
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        private ExplosedHandler() {
        }

        public void install(EffectPanel effectPanel) {
            effectPanel.addMouseListener(this);
            effectPanel.addKeyListener(this);
            effectPanel.addMouseMotionListener(this);
        }

        private void dispose() {
            JExplose.this._effectPanel.removeMouseListener(this);
            JExplose.this._effectPanel.removeKeyListener(this);
            JExplose.this._effectPanel.removeMouseMotionListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Thumbnail thumbnail = JExplose.this._layout.getThumbnailAt(mouseEvent.getPoint());
            if (thumbnail != null) {
                this.dispose();
                JExplose.this.implose(thumbnail);
            }
            mouseEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                this.dispose();
                JExplose.this.implose(null);
            }
            keyEvent.consume();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Thumbnail thumbnail = JExplose.this._layout.getThumbnailAt(mouseEvent.getPoint());
            if (JExplose.this._layout.select(thumbnail)) {
                JExplose.this._effectPanel.repaint();
            }
            mouseEvent.consume();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }
    }
}

