/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.jexplose;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDesktopPane;
import org.jdesktop.swingx.jexplose.core.Painter;

public class Explosable {
    private JDesktopPane _desktop;
    private double _scale = 1.0;
    private AffineTransform _t;
    private List _painters = new ArrayList();
    private transient boolean _doEffect;

    public Explosable(JDesktopPane jDesktopPane) {
        this._desktop = jDesktopPane;
    }

    public JDesktopPane getDesktop() {
        return this._desktop;
    }

    void setScale(double d) {
        this._scale = d;
        this.getDesktop().repaint();
    }

    public void start() {
        this._doEffect = true;
    }

    public void end() {
        this._doEffect = false;
    }

    public void preparePaint(Graphics graphics) {
        this._t = ((Graphics2D)graphics).getTransform();
        if (this._doEffect) {
            ((Graphics2D)graphics).scale(this._scale, this._scale);
            graphics.translate(0, -this._desktop.getHeight());
        }
    }

    public void finishPaint(Graphics graphics) {
        ((Graphics2D)graphics).setTransform(this._t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPainter(Painter painter) {
        painter.prepare(this._desktop);
        List list = this._painters;
        synchronized (list) {
            this._painters.add(painter);
        }
        this._desktop.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePainter(Painter painter) {
        List list = this._painters;
        synchronized (list) {
            if (this._painters.remove(painter)) {
                painter.dispose();
            }
        }
        this._desktop.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preparePaintChildren(Graphics graphics) {
        if (this._doEffect) {
            ArrayList arrayList;
            Object object = this._painters;
            synchronized (object) {
                arrayList = new ArrayList(this._painters);
            }
            object = arrayList.listIterator();
            while (object.hasNext()) {
                Painter painter = (Painter)object.next();
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setTransform(this._t);
                painter.paint(graphics2D);
            }
        }
    }
}

