/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jdbi;

import griffon.plugins.jdbi.JdbiProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.skife.jdbi.v2.DBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbiProvider
implements JdbiProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbiProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withJdbi(Closure<R> closure) {
        return this.withJdbi(DEFAULT, closure);
    }

    @Override
    public <R> R withJdbi(String dataSourceName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)dataSourceName)) {
            dataSourceName = DEFAULT;
        }
        if (closure != null) {
            DBI dbi = this.getJdbi(dataSourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statements on datasource '" + dataSourceName + "'");
            }
            return (R)closure.call(new Object[]{dataSourceName, dbi});
        }
        return null;
    }

    @Override
    public <R> R withJdbi(CallableWithArgs<R> callable) {
        return this.withJdbi(DEFAULT, callable);
    }

    @Override
    public <R> R withJdbi(String dataSourceName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)dataSourceName)) {
            dataSourceName = DEFAULT;
        }
        if (callable != null) {
            DBI dbi = this.getJdbi(dataSourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statements on datasource '" + dataSourceName + "'");
            }
            return (R)callable.call(new Object[]{dataSourceName, dbi});
        }
        return null;
    }

    protected abstract DBI getJdbi(String var1);
}

