/*
 * Decompiled with CFR 0.152.
 */
package lombok.intellij.processor.clazz;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.lombok.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.lombok.psi.LombokPsiElementFactory;
import de.plushnikov.intellij.lombok.util.PsiMethodUtil;
import de.plushnikov.intellij.lombok.util.PsiPrimitiveTypeFactory;
import griffon.plugins.jdbi.JdbiAware;
import java.util.List;
import lombok.core.handlers.JdbiAwareConstants;
import lombok.core.util.MethodDescriptor;
import lombok.intellij.processor.clazz.AbstractGriffonLombokClassProcessor;
import org.jetbrains.annotations.NotNull;

public class JdbiAwareProcessor
extends AbstractGriffonLombokClassProcessor
implements JdbiAwareConstants {
    private static final String JDBI_PROVIDER_FIELD_INITIALIZER = "griffon.plugins.jdbi.DefaultJdbiProvider.getInstance()";

    public JdbiAwareProcessor() {
        super(JdbiAware.class, PsiMethod.class);
    }

    protected <Psi extends PsiElement> void processIntern(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<Psi> target) {
        PsiElementFactory psiElementFactory = this.psiElementFactory(psiClass);
        PsiManager manager = psiClass.getContainingFile().getManager();
        PsiType psiProviderType = psiElementFactory.createTypeFromText("griffon.plugins.jdbi.JdbiProvider", (PsiElement)psiClass);
        LombokLightFieldBuilder providerField = LombokPsiElementFactory.getInstance().createLightField(manager, "this$JdbiProvider", psiProviderType).withContainingClass(psiClass).withModifier("private").withNavigationElement((PsiElement)psiAnnotation);
        PsiExpression initializer = psiElementFactory.createExpressionFromText(String.format(JDBI_PROVIDER_FIELD_INITIALIZER, new Object[0]), (PsiElement)psiClass);
        providerField.setInitializer(initializer);
        LombokLightMethodBuilder method = LombokPsiElementFactory.getInstance().createLightMethod(psiClass.getManager(), "getJdbiProvider").withMethodReturnType(psiProviderType).withContainingClass(psiClass).withModifier("public").withNavigationElement((PsiElement)psiAnnotation);
        target.add(method);
        method = LombokPsiElementFactory.getInstance().createLightMethod(psiClass.getManager(), "setJdbiProvider").withMethodReturnType(PsiPrimitiveTypeFactory.getInstance().getVoidType()).withContainingClass(psiClass).withParameter("provider", psiProviderType).withModifier("public").withNavigationElement((PsiElement)psiAnnotation);
        target.add(method);
        for (MethodDescriptor methodDesc : METHODS) {
            target.add(PsiMethodUtil.createMethod((PsiClass)psiClass, (String)methodDesc.signature, (PsiElement)psiAnnotation));
        }
    }
}

