/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.jdbi.JdbiAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.JdbiAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleJdbiAware
extends EclipseAnnotationHandler<JdbiAware> {
    private final EclipseJdbiAwareHandler handler = new EclipseJdbiAwareHandler();

    public void handle(AnnotationValues<JdbiAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(JdbiAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.jdbi.JdbiContributionHandler", (Annotation)source);
        this.handler.addJdbiProviderField(type);
        this.handler.addJdbiProviderAccessors(type);
        this.handler.addJdbiContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseJdbiAwareHandler
    extends JdbiAwareHandler<EclipseType> {
        private EclipseJdbiAwareHandler() {
        }
    }
}

