/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.jcr.JcrAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.JcrAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleJcrAware
extends EclipseAnnotationHandler<JcrAware> {
    private final EclipseJcrAwareHandler handler = new EclipseJcrAwareHandler();

    public void handle(AnnotationValues<JcrAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(JcrAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.jcr.JcrContributionHandler", (Annotation)source);
        this.handler.addJcrProviderField(type);
        this.handler.addJcrProviderAccessors(type);
        this.handler.addJcrContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseJcrAwareHandler
    extends JcrAwareHandler<EclipseType> {
        private EclipseJcrAwareHandler() {
        }
    }
}

