/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jcr;

import griffon.plugins.jcr.JcrProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJcrProvider
implements JcrProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJcrProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withJcr(Closure<R> closure) {
        return this.withJcr(DEFAULT, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withJcr(String repositoryName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)repositoryName)) {
            repositoryName = DEFAULT;
        }
        if (closure != null) {
            Session session = this.getSession(repositoryName);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing statement on session '" + repositoryName + "'");
                }
                Object object = closure.call(new Object[]{repositoryName, session});
                return (R)object;
            }
            finally {
                session.logout();
            }
        }
        return null;
    }

    @Override
    public <R> R withJcr(CallableWithArgs<R> callable) {
        return this.withJcr(DEFAULT, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withJcr(String repositoryName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)repositoryName)) {
            repositoryName = DEFAULT;
        }
        if (callable != null) {
            Session session = this.getSession(repositoryName);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing statement on session '" + repositoryName + "'");
                }
                callable.setArgs(new Object[]{repositoryName, session});
                Object object = callable.call();
                return (R)object;
            }
            finally {
                session.logout();
            }
        }
        return null;
    }

    protected abstract Session getSession(String var1);
}

