/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.ast;

import griffon.plugins.jcr.DefaultJcrProvider;
import griffon.plugins.jcr.JcrAware;
import griffon.plugins.jcr.JcrContributionHandler;
import griffon.plugins.jcr.JcrProvider;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.core.handlers.JcrAwareConstants;
import org.codehaus.griffon.ast.AbstractASTTransformation;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class JcrAwareASTTransformation
extends AbstractASTTransformation
implements JcrAwareConstants {
    private static final Logger LOG = LoggerFactory.getLogger(JcrAwareASTTransformation.class);
    private static final ClassNode JCR_CONTRIBUTION_HANDLER_CNODE = JcrAwareASTTransformation.makeClassSafe(JcrContributionHandler.class);
    private static final ClassNode JCR_AWARE_CNODE = JcrAwareASTTransformation.makeClassSafe(JcrAware.class);
    private static final ClassNode JCR_PROVIDER_CNODE = JcrAwareASTTransformation.makeClassSafe(JcrProvider.class);
    private static final ClassNode DEFAULT_JCR_PROVIDER_CNODE = JcrAwareASTTransformation.makeClassSafe(DefaultJcrProvider.class);
    private static final String[] DELEGATING_METHODS = new String[]{"withJcr"};

    public static boolean hasJcrAwareAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!JCR_AWARE_CNODE.equals((Object)annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.checkNodesForAnnotationAndType(nodes[0], nodes[1]);
        JcrAwareASTTransformation.addJcrContributionIfNeeded(source, (ClassNode)nodes[1]);
    }

    public static void addJcrContributionIfNeeded(SourceUnit source, ClassNode classNode) {
        if (JcrAwareASTTransformation.needsJcrContribution(classNode, source)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + JcrContributionHandler.class.getName() + " into " + classNode.getName());
            }
            JcrAwareASTTransformation.apply(classNode);
        }
    }

    protected static boolean needsJcrContribution(ClassNode declaringClass, SourceUnit sourceUnit) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        boolean found4 = false;
        for (ClassNode consideredClass = declaringClass; consideredClass != null; consideredClass = consideredClass.getSuperClass()) {
            for (MethodNode method : consideredClass.getMethods()) {
                found1 = method.getName().equals("withJcr") && method.getParameters().length == 1;
                found2 = method.getName().equals("withJcr") && method.getParameters().length == 2;
                found3 = method.getName().equals("setJcrProvider") && method.getParameters().length == 1;
                boolean bl = found4 = method.getName().equals("getJcrProvider") && method.getParameters().length == 0;
                if (!found1 || !found2 || !found3 || !found4) continue;
                return false;
            }
        }
        if (found1 || found2 || found3 || found4) {
            sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage("@JcrAware cannot be processed on " + declaringClass.getName() + " because some but not all of methods from " + JcrContributionHandler.class.getName() + " were declared in the current class or super classes.", (ProcessingUnit)sourceUnit));
            return false;
        }
        return true;
    }

    public static void apply(ClassNode declaringClass) {
        GriffonASTUtils.injectInterface((ClassNode)declaringClass, (ClassNode)JCR_CONTRIBUTION_HANDLER_CNODE);
        FieldNode providerField = declaringClass.addField("this$jcrProvider", 4098, JCR_PROVIDER_CNODE, JcrAwareASTTransformation.defaultJcrProviderInstance());
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("getJcrProvider", 1, JCR_PROVIDER_CNODE, Parameter.EMPTY_ARRAY, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.field((FieldNode)providerField))));
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("setJcrProvider", 1, ClassHelper.VOID_TYPE, GriffonASTUtils.params((Parameter[])new Parameter[]{GriffonASTUtils.param((ClassNode)JCR_PROVIDER_CNODE, (String)"provider")}), GriffonASTUtils.NO_EXCEPTIONS, (Statement)GriffonASTUtils.block((Statement[])new Statement[]{GriffonASTUtils.ifs_no_return((Expression)GriffonASTUtils.cmp((Expression)GriffonASTUtils.var((String)"provider"), (Expression)ConstantExpression.NULL), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)JcrAwareASTTransformation.defaultJcrProviderInstance()), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)GriffonASTUtils.var((String)"provider")))})));
        for (MethodNode method : JCR_CONTRIBUTION_HANDLER_CNODE.getMethods()) {
            if (Arrays.binarySearch(DELEGATING_METHODS, method.getName()) < 0) continue;
            ArrayList<VariableExpression> variables = new ArrayList<VariableExpression>();
            Parameter[] parameters = new Parameter[method.getParameters().length];
            for (int i = 0; i < method.getParameters().length; ++i) {
                Parameter p = method.getParameters()[i];
                parameters[i] = new Parameter(JcrAwareASTTransformation.makeClassSafe((ClassNode)p.getType()), p.getName());
                parameters[i].getType().setGenericsTypes(p.getType().getGenericsTypes());
                variables.add(GriffonASTUtils.var((String)p.getName()));
            }
            ClassNode returnType = JcrAwareASTTransformation.makeClassSafe((ClassNode)method.getReturnType());
            returnType.setGenericsTypes(method.getReturnType().getGenericsTypes());
            returnType.setGenericsPlaceHolder(method.getReturnType().isGenericsPlaceHolder());
            MethodNode newMethod = new MethodNode(method.getName(), 1, returnType, parameters, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.call((Expression)GriffonASTUtils.field((FieldNode)providerField), (String)method.getName(), (ArgumentListExpression)GriffonASTUtils.args(variables))));
            newMethod.setGenericsTypes(method.getGenericsTypes());
            GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)newMethod);
        }
    }

    private static Expression defaultJcrProviderInstance() {
        return GriffonASTUtils.call((ClassNode)DEFAULT_JCR_PROVIDER_CNODE, (String)"getInstance", (ArgumentListExpression)GriffonASTUtils.NO_ARGS);
    }

    static {
        Arrays.sort(DELEGATING_METHODS);
    }
}

