/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.text;

import com.wordpress.tipsforjava.swing.text.ChainedDocumentFilter;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class SizeDocumentFilter
extends ChainedDocumentFilter {
    private int size;
    private boolean autoTab = true;

    public SizeDocumentFilter() {
        this(0);
    }

    public SizeDocumentFilter(int size) {
        this(size, null);
    }

    public SizeDocumentFilter(int size, DocumentFilter filter) {
        super(filter);
        this.setSize(size);
    }

    public boolean getAutoTab() {
        return this.autoTab;
    }

    public void setAutoTab(boolean autoTab) {
        this.autoTab = autoTab;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
        int allowedSize;
        int possibleSize = fb.getDocument().getLength() + str.length();
        if (possibleSize <= (allowedSize = this.getAllowedSize(fb))) {
            super.insertString(fb, offs, str, a);
            this.handleAutoTab(possibleSize, allowedSize, fb);
        } else {
            this.provideErrorFeedback();
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
        int allowedSize;
        int possibleSize = fb.getDocument().getLength() + str.length() - length;
        if (possibleSize <= (allowedSize = this.getAllowedSize(fb))) {
            super.replace(fb, offs, length, str, a);
            this.handleAutoTab(possibleSize, allowedSize, fb);
        } else {
            this.provideErrorFeedback();
        }
    }

    private int getAllowedSize(DocumentFilter.FilterBypass fb) {
        return this.size == 0 ? this.getColumns(fb) : this.size;
    }

    private int getColumns(DocumentFilter.FilterBypass fb) {
        JTextField textField;
        Document doc;
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null && c instanceof JTextField && (doc = (textField = (JTextField)c).getDocument()).equals(fb.getDocument())) {
            return textField.getColumns();
        }
        return 0;
    }

    protected void handleAutoTab(int possibleSize, int allowedSize, DocumentFilter.FilterBypass fb) {
        JTextComponent component;
        Document doc;
        if (!this.autoTab || possibleSize != allowedSize) {
            return;
        }
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null && c instanceof JTextComponent && (doc = (component = (JTextComponent)c).getDocument()).equals(fb.getDocument())) {
            c.transferFocus();
        }
    }
}

