/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

class SelectAllRenderer
extends DefaultTableCellRenderer {
    private Color selectionBackground;
    private Border editBorder = BorderFactory.createLineBorder(Color.BLACK);
    private boolean isPaintSelection;

    public SelectAllRenderer() {
        this(UIManager.getColor("TextField.selectionBackground"));
    }

    public SelectAllRenderer(Color selectionBackground) {
        this.selectionBackground = selectionBackground;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.isPaintSelection = hasFocus && table.isCellEditable(row, column) && !this.getText().equals("");
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isPaintSelection) {
            this.setBorder(this.editBorder);
            g.setColor(UIManager.getColor("Table.focusCellBackground"));
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(this.selectionBackground);
            g.fillRect(0, 0, this.getPreferredSize().width, this.getSize().height);
            this.setOpaque(false);
        }
        super.paintComponent(g);
        this.setOpaque(true);
    }
}

