/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.table;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class LeftDotRenderer
extends DefaultTableCellRenderer {
    LeftDotRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int availableWidth = table.getColumnModel().getColumn(column).getWidth();
        availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
        Insets borderInsets = this.getBorder().getBorderInsets(this);
        String cellText = this.getText();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
            int i;
            String dots = "...";
            int textWidth = fm.stringWidth(dots);
            for (i = cellText.length() - 1; i > 0 && (textWidth += fm.charWidth(cellText.charAt(i))) <= availableWidth; --i) {
            }
            this.setText(dots + cellText.substring(i + 1));
        }
        return this;
    }
}

