/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.table;

import com.wordpress.tipsforjava.swing.table.RowTableModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanTableModel<T>
extends RowTableModel<T> {
    private static Map<Class, Class> primitives = new HashMap<Class, Class>(10);
    private Class beanClass;
    private Class ancestorClass;
    private List<ColumnInformation> columns = new ArrayList<ColumnInformation>();

    public BeanTableModel(Class beanClass) {
        this(beanClass, beanClass, new ArrayList());
    }

    public BeanTableModel(Class beanClass, Class ancestorClass) {
        this(beanClass, ancestorClass, new ArrayList());
    }

    public BeanTableModel(Class beanClass, List<T> modelData) {
        this(beanClass, beanClass, modelData);
    }

    public BeanTableModel(Class beanClass, Class ancestorClass, List<T> modelData) {
        super(beanClass);
        this.beanClass = beanClass;
        this.ancestorClass = ancestorClass;
        this.createColumnInformation();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnInformation info : this.columns) {
            columnNames.add(info.getName());
        }
        super.setDataAndColumnNames(modelData, columnNames);
        this.resetModelDefaults();
    }

    private void createColumnInformation() {
        Method[] theMethods = this.beanClass.getMethods();
        for (int i = 0; i < theMethods.length; ++i) {
            Method theMethod = theMethods[i];
            if (theMethod.getParameterTypes().length != 0 || !this.ancestorClass.isAssignableFrom(theMethod.getDeclaringClass())) continue;
            String methodName = theMethod.getName();
            if (theMethod.getName().startsWith("get")) {
                this.buildColumnInformation(theMethod, methodName.substring(3));
            }
            if (!theMethod.getName().startsWith("is")) continue;
            this.buildColumnInformation(theMethod, methodName.substring(2));
        }
    }

    private void buildColumnInformation(Method theMethod, String theMethodName) {
        Class returnType = this.getReturnType(theMethod);
        if (returnType == null) {
            return;
        }
        String headerName = BeanTableModel.formatColumnName(theMethodName);
        Method setMethod = null;
        try {
            String setMethodName = "set" + theMethodName;
            setMethod = this.beanClass.getMethod(setMethodName, theMethod.getReturnType());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        ColumnInformation ci = new ColumnInformation(headerName, returnType, theMethod, setMethod);
        this.columns.add(ci);
    }

    private Class getReturnType(Method theMethod) {
        Class returnType = theMethod.getReturnType();
        if (returnType.isInterface() || returnType.isArray()) {
            return null;
        }
        if (returnType.isPrimitive()) {
            returnType = primitives.get(returnType);
        }
        return returnType;
    }

    private void resetModelDefaults() {
        this.columnNames.clear();
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnInformation info = this.columns.get(i);
            this.columnNames.add(info.getName());
            super.setColumnClass(i, info.getReturnType());
            super.setColumnEditable(i, info.getSetter() != null);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        ColumnInformation ci = this.columns.get(column);
        Object value = null;
        try {
            value = ci.getGetter().invoke(this.getRow(row), new Object[0]);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        ColumnInformation ci = this.columns.get(column);
        try {
            Method setMethod = ci.getSetter();
            if (setMethod != null) {
                setMethod.invoke(this.getRow(row), value);
                this.fireTableCellUpdated(row, column);
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    @Override
    public void setColumnClass(int column, Class columnClass) {
    }

    @Override
    public void setColumnEditable(int column, boolean isEditable) {
        ColumnInformation ci = this.columns.get(column);
        if (isEditable && ci.getSetter() == null) {
            return;
        }
        super.setColumnEditable(column, isEditable);
    }

    public void setColumnName(int column, String name) {
        ColumnInformation ci = this.columns.get(column);
        ci.setName(name);
        this.resetModelDefaults();
    }

    public void sortColumnNames() {
        Collections.sort(this.columns);
        this.resetModelDefaults();
    }

    static {
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Short.TYPE, Short.class);
    }

    private class ColumnInformation
    implements Comparable<ColumnInformation> {
        private String name;
        private Class returnType;
        private Method getter;
        private Method setter;

        public ColumnInformation(String name, Class returnType, Method getter, Method setter) {
            this.name = name;
            this.returnType = returnType;
            this.getter = getter;
            this.setter = setter;
        }

        public Class getReturnType() {
            return this.returnType;
        }

        public Method getGetter() {
            return this.getter;
        }

        public String getName() {
            return this.name;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(ColumnInformation o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

