/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.border;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ComponentBorder
implements Border {
    public static final float LEADING = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float TRAILING = 1.0f;
    private JComponent parent;
    private JComponent component;
    private Edge edge;
    private float alignment;
    private int gap = 5;
    private boolean adjustInsets = true;
    private Insets borderInsets = new Insets(0, 0, 0, 0);

    public ComponentBorder(JComponent component) {
        this(component, Edge.RIGHT);
    }

    public ComponentBorder(JComponent component, Edge edge) {
        this(component, edge, 0.5f);
    }

    public ComponentBorder(JComponent component, Edge edge, float alignment) {
        this.component = component;
        component.setSize(component.getPreferredSize());
        component.setCursor(Cursor.getDefaultCursor());
        this.setEdge(edge);
        this.setAlignment(alignment);
    }

    public boolean isAdjustInsets() {
        return this.adjustInsets;
    }

    public void setAdjustInsets(boolean adjustInsets) {
        this.adjustInsets = adjustInsets;
    }

    public float getAlignment() {
        return this.alignment;
    }

    public void setAlignment(float alignment) {
        this.alignment = alignment > 1.0f ? 1.0f : (alignment < 0.0f ? 0.0f : alignment);
    }

    public Edge getEdge() {
        return this.edge;
    }

    public void setEdge(Edge edge) {
        this.edge = edge;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.borderInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        float x2 = (float)(width - this.component.getWidth()) * this.component.getAlignmentX() + (float)x;
        float y2 = (float)(height - this.component.getHeight()) * this.component.getAlignmentY() + (float)y;
        this.component.setLocation((int)x2, (int)y2);
    }

    public void install(JComponent parent) {
        this.parent = parent;
        this.determineInsetsAndAlignment();
        Border current = parent.getBorder();
        if (current == null) {
            parent.setBorder(this);
        } else {
            CompoundBorder compound = new CompoundBorder(current, this);
            parent.setBorder(compound);
        }
        parent.add(this.component);
    }

    private void determineInsetsAndAlignment() {
        this.borderInsets = new Insets(0, 0, 0, 0);
        if (this.edge == Edge.TOP) {
            this.borderInsets.top = this.component.getPreferredSize().height + this.gap;
            this.component.setAlignmentX(this.alignment);
            this.component.setAlignmentY(0.0f);
        } else if (this.edge == Edge.BOTTOM) {
            this.borderInsets.bottom = this.component.getPreferredSize().height + this.gap;
            this.component.setAlignmentX(this.alignment);
            this.component.setAlignmentY(1.0f);
        } else if (this.edge == Edge.LEFT) {
            this.borderInsets.left = this.component.getPreferredSize().width + this.gap;
            this.component.setAlignmentX(0.0f);
            this.component.setAlignmentY(this.alignment);
        } else if (this.edge == Edge.RIGHT) {
            this.borderInsets.right = this.component.getPreferredSize().width + this.gap;
            this.component.setAlignmentX(1.0f);
            this.component.setAlignmentY(this.alignment);
        }
        if (this.adjustInsets) {
            this.adjustBorderInsets();
        }
    }

    private void adjustBorderInsets() {
        int diff;
        Insets parentInsets = this.parent.getInsets();
        if (this.edge == Edge.RIGHT || this.edge == Edge.LEFT) {
            int parentHeight = this.parent.getPreferredSize().height - parentInsets.top - parentInsets.bottom;
            diff = this.component.getHeight() - parentHeight;
            if (diff > 0) {
                int topDiff = (int)((float)diff * this.alignment);
                int bottomDiff = diff - topDiff;
                this.borderInsets.top += topDiff;
                this.borderInsets.bottom += bottomDiff;
            }
        }
        if (this.edge == Edge.TOP || this.edge == Edge.BOTTOM) {
            int parentWidth = this.parent.getPreferredSize().width - parentInsets.left - parentInsets.right;
            diff = this.component.getWidth() - parentWidth;
            if (diff > 0) {
                int leftDiff = (int)((float)diff * this.alignment);
                int rightDiff = diff - leftDiff;
                this.borderInsets.left += leftDiff;
                this.borderInsets.right += rightDiff;
            }
        }
    }

    public static enum Edge {
        TOP,
        LEFT,
        BOTTOM,
        RIGHT;

    }
}

