/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.URL;
import javax.swing.ImageIcon;

public class TileIcon
extends ImageIcon {
    private TileMode tileMode = TileMode.DEFAULT;

    public TileIcon(byte[] imageData) {
        super(imageData);
    }

    public TileIcon(byte[] imageData, String description) {
        super(imageData, description);
    }

    public TileIcon(Image image) {
        super(image);
    }

    public TileIcon(Image image, String description) {
        super(image, description);
    }

    public TileIcon(String filename) {
        super(filename);
    }

    public TileIcon(String filename, String description) {
        super(filename, description);
    }

    public TileIcon(URL location) {
        super(location);
    }

    public TileIcon(URL location, String description) {
        super(location, description);
    }

    public void setTileMode(TileMode tileMode) {
        this.tileMode = tileMode;
    }

    public TileMode getTileMode() {
        return this.tileMode;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Image image = this.getImage();
        if (image == null) {
            return;
        }
        Shape clip = g.getClip();
        int iw = image.getWidth(c);
        int ih = image.getHeight(c);
        Insets insets = ((Container)c).getInsets();
        int w = c.getWidth();
        int h = c.getHeight();
        x = insets.left;
        y = insets.top;
        int x1 = c.getWidth() - insets.right;
        int y1 = c.getHeight() - insets.bottom;
        g.setClip(new Rectangle(x, y, x1 - x, y1 - y));
        if (this.tileMode != TileMode.DEFAULT) {
            int centerX = (x + x1) / 2;
            int centerY = (y + y1) / 2;
            switch (this.tileMode) {
                case CENTER_CORNER: {
                    x += (centerX - x) % iw - iw;
                    y += (centerY - y) % ih - ih;
                    break;
                }
                case CENTER_CENTER: {
                    x += (centerX - iw / 2 - x) % iw - iw;
                    y += (centerY - ih / 2 - y) % ih - ih;
                }
            }
        }
        for (int ix = x; ix <= x1; ix += iw) {
            for (int iy = y; iy < y1; iy += ih) {
                super.paintIcon(c, g, ix, iy);
            }
        }
        g.setClip(clip);
    }

    @Override
    public int getIconWidth() {
        return 0;
    }

    @Override
    public int getIconHeight() {
        return 0;
    }

    public static enum TileMode {
        DEFAULT,
        CENTER_CORNER,
        CENTER_CENTER;

    }
}

