/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import com.wordpress.tipsforjava.swing.ShrinkIcon;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;

public class ThumbnailIcon
extends ShrinkIcon {
    public static final int DEFAULT = -1;
    public static final int COMPUTED = 0;
    private static int defaultWidth = 160;
    private static int defaultHeight = 120;
    private int thumbWidth = -1;
    private int thumbHeight = -1;

    public ThumbnailIcon(byte[] imageData) {
        super(imageData);
    }

    public ThumbnailIcon(byte[] imageData, String description) {
        super(imageData, description);
    }

    public ThumbnailIcon(Image image) {
        super(image);
    }

    public ThumbnailIcon(Image image, String description) {
        super(image, description);
    }

    public ThumbnailIcon(String filename) {
        super(filename);
    }

    public ThumbnailIcon(String filename, String description) {
        super(filename, description);
    }

    public ThumbnailIcon(URL location) {
        super(location);
    }

    public ThumbnailIcon(URL location, String description) {
        super(location, description);
    }

    public void setThumbWidth(int width) {
        if (width < -1) {
            throw new IllegalArgumentException("Width cannot be less than ThumbnailIcon.DEFAULT");
        }
        this.thumbWidth = width;
    }

    public int getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbHeight(int height) {
        if (height < -1) {
            throw new IllegalArgumentException("Height cannot be less than ThumbnailIcon.DEFAULT");
        }
        this.thumbHeight = height;
    }

    public int getThumbHeight() {
        return this.thumbHeight;
    }

    public static void setDefaultSize(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Default width and/or height cannot be negative");
        }
        defaultWidth = width;
        defaultHeight = height;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    @Override
    public int getIconWidth() {
        if (this.thumbWidth > 0) {
            return this.thumbWidth;
        }
        Image image = this.getImage();
        int w = image.getWidth(component);
        int h = image.getHeight(component);
        if (this.thumbWidth < 0) {
            if (defaultWidth > 0) {
                return defaultWidth;
            }
            if (defaultHeight > 0) {
                return defaultHeight * w / h;
            }
            if (this.thumbHeight <= 0) {
                return w;
            }
        }
        return this.getIconHeight() * w / h;
    }

    @Override
    public int getIconHeight() {
        if (this.thumbHeight > 0) {
            return this.thumbHeight;
        }
        Image image = this.getImage();
        int w = image.getWidth(component);
        int h = image.getHeight(component);
        if (this.thumbHeight < 0) {
            if (defaultHeight > 0) {
                return defaultHeight;
            }
            if (defaultWidth > 0) {
                return defaultWidth * h / w;
            }
            if (this.thumbWidth <= 0) {
                return h;
            }
        }
        return this.getIconWidth() * h / w;
    }

    public BufferedImage getThumbnail() {
        Image image = this.getImage();
        int w = image.getWidth(component);
        int h = image.getHeight(component);
        int tw = this.getIconWidth();
        int th = this.getIconHeight();
        if (w * th < h * tw) {
            tw = th * w / h;
        } else {
            th = tw * h / w;
        }
        tw = tw > w ? w : tw;
        th = th > h ? h : th;
        BufferedImage retVal = new BufferedImage(tw, th, 1);
        image.getGraphics().drawImage(this.getImage(), 0, 0, tw, th, component);
        return retVal;
    }
}

