/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.event.SwingPropertyChangeSupport;

public class SelectButtonGroup
extends ButtonGroup
implements Serializable {
    static Vector<AbstractButton> allButtons = new Vector();
    AbstractButton selectedButton = null;
    protected boolean enabled = true;
    private SwingPropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this);

    @Override
    public void add(AbstractButton button) {
        if (button == null) {
            return;
        }
        if (this.buttons.contains(button)) {
            throw new IllegalArgumentException("Button already added to group");
        }
        if (allButtons.contains(button)) {
            throw new IllegalArgumentException("Button cannot be added to two groups");
        }
        ButtonModel model = button.getModel();
        if (model instanceof DefaultButtonModel) {
            DefaultButtonModel dbModel = (DefaultButtonModel)button.getModel();
            ButtonGroup oldGroup = dbModel.getGroup();
            if (oldGroup != null) {
                throw new IllegalArgumentException("Button cannot be added to two groups");
            }
        } else {
            try {
                ButtonGroup oldGroup;
                Class<?> clazz = model.getClass();
                Method method = clazz.getMethod("getGroup", new Class[0]);
                method.setAccessible(true);
                if (method.getReturnType().isAssignableFrom(ButtonGroup.class) && (oldGroup = (ButtonGroup)method.invoke((Object)model, new Object[0])) != null) {
                    throw new IllegalArgumentException("Button cannot be added to two groups");
                }
            }
            catch (IllegalAccessException ignore) {
            }
            catch (IllegalArgumentException ignore) {
            }
            catch (InvocationTargetException ignore) {
            }
            catch (NoSuchMethodException ignore) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        button.setEnabled(this.enabled);
        allButtons.add(button);
        super.add(button);
    }

    @Override
    public void remove(AbstractButton button) {
        if (button == null) {
            return;
        }
        allButtons.remove(button);
        super.remove(button);
        if (this.selectedButton == button) {
            this.selectedButton = null;
        }
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        AbstractButton oldSelection = this.selectedButton;
        this.selectedButton = null;
        this.firePropertyChanged("selectedButton", oldSelection, null);
    }

    @Override
    public void setSelected(ButtonModel model, boolean selected) {
        if (selected && model != null && model != this.getSelection()) {
            super.setSelected(model, selected);
            for (AbstractButton button : this.buttons) {
                if (button.getModel() != model) continue;
                AbstractButton oldSelection = this.selectedButton;
                this.selectedButton = button;
                this.firePropertyChanged("selectedButton", oldSelection, button);
                return;
            }
        }
    }

    public void setSelectedButton(AbstractButton button) {
        this.setSelected(button.getModel(), true);
    }

    public AbstractButton getSelectedButton() {
        return this.selectedButton;
    }

    public boolean isSelected(AbstractButton button) {
        return button == this.selectedButton;
    }

    public void setSelectedIndex(int index) {
        if (index < this.buttons.size()) {
            this.setSelectedButton((AbstractButton)this.buttons.get(index));
        }
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (this.buttons.get(i) != this.selectedButton) continue;
            return i;
        }
        return -1;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        for (AbstractButton button : this.buttons) {
            button.setEnabled(enable);
        }
    }

    public void dispose() {
        for (AbstractButton button : this.buttons) {
            this.remove(button);
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
    }
}

