/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FontMetrics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupMenuAlignment
implements ContainerListener {
    public static int CENTER = 0;
    public static int TRAILING = 11;
    private int alignment;

    public PopupMenuAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        JPopupMenu popup = (JPopupMenu)e.getContainer();
        PopupMenuAlignment.alignText(popup, this.alignment);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        JPopupMenu popup = (JPopupMenu)e.getContainer();
        PopupMenuAlignment.alignText(popup, this.alignment);
    }

    public static void alignText(JPopupMenu popup, int alignment) {
        JMenuItem menuItem;
        Component c;
        int i;
        int maxWidth = 0;
        for (i = 0; i < popup.getComponentCount(); ++i) {
            c = popup.getComponent(i);
            if (!(c instanceof JMenuItem)) continue;
            menuItem = (JMenuItem)c;
            FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
            maxWidth = Math.max(maxWidth, fm.stringWidth(menuItem.getText().trim()));
        }
        for (i = 0; i < popup.getComponentCount(); ++i) {
            c = popup.getComponent(i);
            if (!(c instanceof JMenuItem)) continue;
            menuItem = (JMenuItem)c;
            String actionCommand = menuItem.getActionCommand();
            String text = menuItem.getText().trim();
            ComponentOrientation orientation = menuItem.getComponentOrientation();
            StringBuffer sb = new StringBuffer();
            if (!orientation.isLeftToRight()) {
                sb.append(text);
            }
            FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
            int spaceWidth = fm.stringWidth(" ") * (alignment == CENTER ? 2 : 1);
            int spaces = (maxWidth - fm.stringWidth(text)) / spaceWidth;
            for (int j = 0; j < spaces; ++j) {
                sb.append(" ");
            }
            if (orientation.isLeftToRight()) {
                sb.append(text);
            }
            menuItem.setText(sb.toString());
            menuItem.setActionCommand(actionCommand);
        }
    }
}

