/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;

public class MouseWheelController
implements MouseWheelListener {
    private JScrollPane scrollPane;
    private int scrollAmount = 0;
    private MouseWheelListener[] realListeners;

    public MouseWheelController(JScrollPane scrollPane) {
        this(scrollPane, 1);
    }

    public MouseWheelController(JScrollPane scrollPane, int scrollAmount) {
        this.scrollPane = scrollPane;
        this.setScrollAmount(scrollAmount);
        this.install();
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public void install() {
        if (this.realListeners != null) {
            return;
        }
        for (MouseWheelListener mwl : this.realListeners = this.scrollPane.getMouseWheelListeners()) {
            this.scrollPane.removeMouseWheelListener(mwl);
        }
        this.scrollPane.addMouseWheelListener(this);
    }

    public void uninstall() {
        if (this.realListeners == null) {
            return;
        }
        this.scrollPane.removeMouseWheelListener(this);
        for (MouseWheelListener mwl : this.realListeners) {
            this.scrollPane.addMouseWheelListener(mwl);
        }
        this.realListeners = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.scrollAmount != 0) {
            e = this.createScrollAmountEvent(e);
        }
        for (MouseWheelListener mwl : this.realListeners) {
            mwl.mouseWheelMoved(e);
        }
    }

    private MouseWheelEvent createScrollAmountEvent(MouseWheelEvent e) {
        MouseWheelEvent mwe = new MouseWheelEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), this.scrollAmount, e.getWheelRotation());
        return mwe;
    }
}

