/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class LinePainter
implements Highlighter.HighlightPainter,
CaretListener,
MouseListener,
MouseMotionListener {
    private JTextComponent component;
    private Color color;
    private Rectangle lastView;

    public LinePainter(JTextComponent component) {
        this(component, null);
        this.setLighter(component.getSelectionColor());
    }

    public LinePainter(JTextComponent component, Color color) {
        this.component = component;
        this.setColor(color);
        component.addCaretListener(this);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        try {
            component.getHighlighter().addHighlight(0, 0, this);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLighter(Color color) {
        int red = Math.min(255, (int)((double)color.getRed() * 1.2));
        int green = Math.min(255, (int)((double)color.getGreen() * 1.2));
        int blue = Math.min(255, (int)((double)color.getBlue() * 1.2));
        this.setColor(new Color(red, green, blue));
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        try {
            Rectangle r = c.modelToView(c.getCaretPosition());
            g.setColor(this.color);
            g.fillRect(0, r.y, c.getWidth(), r.height);
            if (this.lastView == null) {
                this.lastView = r;
            }
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
    }

    private void resetHighlight() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int offset = LinePainter.this.component.getCaretPosition();
                    Rectangle currentView = LinePainter.this.component.modelToView(offset);
                    if (((LinePainter)LinePainter.this).lastView.y != currentView.y) {
                        LinePainter.this.component.repaint(0, ((LinePainter)LinePainter.this).lastView.y, LinePainter.this.component.getWidth(), ((LinePainter)LinePainter.this).lastView.height);
                        LinePainter.this.lastView = currentView;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.resetHighlight();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.resetHighlight();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.resetHighlight();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

