/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import javax.swing.Timer;

public class JumpScrollBarModel
extends DefaultBoundedRangeModel
implements SwingConstants {
    private JScrollBar scrollBar;
    private BoundedRangeModel oldModel;
    private int oldValue;
    private Timer timer = new Timer(1000, new ActionListener(){
        int lastValue;
        {
            this.lastValue = JumpScrollBarModel.this.getTrueValue();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.lastValue != JumpScrollBarModel.this.getTrueValue()) {
                this.lastValue = JumpScrollBarModel.this.getTrueValue();
                JumpScrollBarModel.this.timer.restart();
                return;
            }
            int newValue = JumpScrollBarModel.this.getTrueValue();
            if (JumpScrollBarModel.this.oldValue != newValue) {
                JumpScrollBarModel.this.oldValue = newValue;
                JumpScrollBarModel.this.fireStateChanged();
            }
        }
    });

    public JumpScrollBarModel() {
    }

    public JumpScrollBarModel(int value, int extent, int min, int max) {
        super(value, extent, min, max);
    }

    public JumpScrollBarModel(JScrollPane scrollPane) {
        this(scrollPane, 1);
    }

    public JumpScrollBarModel(JScrollPane scrollPane, int scrollBarType) {
        this(scrollBarType == 0 ? scrollPane.getHorizontalScrollBar() : scrollPane.getVerticalScrollBar());
    }

    public JumpScrollBarModel(JScrollBar scrollBar) {
        this.scrollBar = scrollBar;
        this.oldModel = scrollBar.getModel();
        this.setValue(this.oldModel.getValue());
        this.setExtent(this.oldModel.getExtent());
        this.setMinimum(this.oldModel.getMinimum());
        this.setMaximum(this.oldModel.getMaximum());
    }

    public static JumpScrollBarModel setJumpScrollBarModel(JScrollPane scrollPane) {
        return JumpScrollBarModel.setJumpScrollBarModel(scrollPane, 1);
    }

    public static JumpScrollBarModel setJumpScrollBarModel(JScrollPane scrollPane, int scrollBarType) {
        return JumpScrollBarModel.setJumpScrollBarModel(scrollBarType == 0 ? scrollPane.getHorizontalScrollBar() : scrollPane.getVerticalScrollBar());
    }

    public static JumpScrollBarModel setJumpScrollBarModel(JScrollBar scrollBar) {
        JumpScrollBarModel model = new JumpScrollBarModel(scrollBar);
        scrollBar.setModel(model);
        return model;
    }

    @Override
    public int getValue() {
        int newValue = this.getTrueValue();
        if (!this.getValueIsAdjusting() && this.oldValue != newValue) {
            this.oldValue = newValue;
            this.fireStateChanged();
        }
        return this.oldValue;
    }

    public int getTrueValue() {
        return super.getValue();
    }

    public int getJumpInterval() {
        if (this.timer.isRunning()) {
            return this.timer.getDelay();
        }
        return -1;
    }

    public void setJumpInterval(int interval) {
        if (interval == -1 && this.timer.isRunning()) {
            this.timer.stop();
        } else if (interval > 0 && interval != this.getJumpInterval()) {
            this.timer.setDelay(interval);
            this.timer.setInitialDelay(interval);
            this.timer.start();
        }
    }

    public void dispose() {
        if (this.scrollBar != null) {
            this.scrollBar.setModel(this.oldModel);
        }
    }
}

