/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class DefaultButtonListener
implements PropertyChangeListener {
    private static String PERMANENT_FOCUS_OWNER = "permanentFocusOwner";
    private HashMap<JRootPane, JButton> rootPanes = new HashMap();
    private Component oldValue;

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getOldValue() != null) {
            this.oldValue = (Component)e.getOldValue();
        }
        if (e.getNewValue() == null) {
            return;
        }
        Component newValue = (Component)e.getNewValue();
        JRootPane oldRootPane = SwingUtilities.getRootPane(this.oldValue);
        JRootPane newRootPane = SwingUtilities.getRootPane(newValue);
        if (newRootPane == oldRootPane && this.oldValue instanceof JButton && !(newValue instanceof JButton)) {
            this.restoreDefaultButton(newRootPane);
        }
        if (newValue instanceof JButton) {
            this.setDefaultButton(newRootPane, (JButton)newValue);
        }
    }

    private void restoreDefaultButton(JRootPane rootPane) {
        if (this.rootPanes.containsKey(rootPane)) {
            JButton savedDefaultButton = this.rootPanes.get(rootPane);
            rootPane.setDefaultButton(savedDefaultButton);
        }
    }

    private void setDefaultButton(JRootPane rootPane, JButton button) {
        if (!this.rootPanes.containsKey(rootPane)) {
            this.rootPanes.put(rootPane, rootPane.getDefaultButton());
        }
        rootPane.setDefaultButton(button);
    }

    static DefaultButtonListener install() {
        DefaultButtonListener listener = new DefaultButtonListener();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(PERMANENT_FOCUS_OWNER, listener);
        return listener;
    }

    static void unInstall(DefaultButtonListener listener) {
        listener.rootPanes.clear();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(PERMANENT_FOCUS_OWNER, listener);
    }
}

