/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ComponentMover
extends MouseAdapter {
    private Class destinationClass;
    private Component destinationComponent;
    private Component destination;
    private Component source;
    private boolean changeCursor = true;
    private Point pressed;
    private Point location;
    private Cursor originalCursor;
    private boolean autoscrolls;
    private Insets dragInsets = new Insets(0, 0, 0, 0);
    private Dimension snapSize = new Dimension(1, 1);

    public ComponentMover() {
    }

    public ComponentMover(Class destinationClass, Component ... components) {
        this.destinationClass = destinationClass;
        this.registerComponent(components);
    }

    public ComponentMover(Component destinationComponent, Component ... components) {
        this.destinationComponent = destinationComponent;
        this.registerComponent(components);
    }

    public boolean isChangeCursor() {
        return this.changeCursor;
    }

    public void setChangeCursor(boolean changeCursor) {
        this.changeCursor = changeCursor;
    }

    public Insets getDragInsets() {
        return this.dragInsets;
    }

    public void setDragInsets(Insets dragInsets) {
        this.dragInsets = dragInsets;
    }

    public void deregisterComponent(Component ... components) {
        for (Component component : components) {
            component.removeMouseListener(this);
        }
    }

    public void registerComponent(Component ... components) {
        for (Component component : components) {
            component.addMouseListener(this);
        }
    }

    public Dimension getSnapSize() {
        return this.snapSize;
    }

    public void setSnapSize(Dimension snapSize) {
        this.snapSize = snapSize;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.source = e.getComponent();
        int width = this.source.getSize().width - this.dragInsets.left - this.dragInsets.right;
        int height = this.source.getSize().height - this.dragInsets.top - this.dragInsets.bottom;
        Rectangle r = new Rectangle(this.dragInsets.left, this.dragInsets.top, width, height);
        if (r.contains(e.getPoint())) {
            this.setupForDragging(e);
        }
    }

    private void setupForDragging(MouseEvent e) {
        this.source.addMouseMotionListener(this);
        this.destination = this.destinationComponent != null ? this.destinationComponent : (this.destinationClass == null ? this.source : SwingUtilities.getAncestorOfClass(this.destinationClass, this.source));
        this.pressed = e.getLocationOnScreen();
        this.location = this.destination.getLocation();
        if (this.changeCursor) {
            this.originalCursor = this.source.getCursor();
            this.source.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (this.destination instanceof JComponent) {
            JComponent jc = (JComponent)this.destination;
            this.autoscrolls = jc.getAutoscrolls();
            jc.setAutoscrolls(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point dragged = e.getLocationOnScreen();
        int dragX = this.getDragDistance(dragged.x, this.pressed.x, this.snapSize.width);
        int dragY = this.getDragDistance(dragged.y, this.pressed.y, this.snapSize.height);
        this.destination.setLocation(this.location.x + dragX, this.location.y + dragY);
    }

    private int getDragDistance(int larger, int smaller, int snapSize) {
        int drag;
        int halfway = snapSize / 2;
        drag += (drag = larger - smaller) < 0 ? -halfway : halfway;
        drag = drag / snapSize * snapSize;
        return drag;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.source.removeMouseMotionListener(this);
        if (this.changeCursor) {
            this.source.setCursor(this.originalCursor);
        }
        if (this.destination instanceof JComponent) {
            ((JComponent)this.destination).setAutoscrolls(this.autoscrolls);
        }
    }
}

