/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.tree;

import com.wordpress.tipsforjava.swing.SwingUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ComponentTreeModel
extends DefaultTreeModel
implements Serializable {
    public ComponentTreeModel(JComponent container) {
        this(container, true);
    }

    public ComponentTreeModel(JComponent container, boolean nested) {
        this(container, new DefaultMutableTreeNode(container), nested);
    }

    private ComponentTreeModel(JComponent container, DefaultMutableTreeNode root, boolean nested) {
        super(root);
        ComponentTreeModel.addNodes(container, this, root, nested);
    }

    public static DefaultTreeModel getComponentTreeModel(JComponent container, DefaultTreeModel model, DefaultMutableTreeNode root, boolean nested) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(container);
        if (model == null) {
            model = new DefaultTreeModel(node);
        }
        if (root == null) {
            root = node;
        }
        if (model.getRoot() == null) {
            model.setRoot(root);
        } else {
            root.add(node);
        }
        ComponentTreeModel.addNodes(container, model, node, nested);
        return model;
    }

    private static void addNodes(JComponent container, DefaultTreeModel model, DefaultMutableTreeNode root, boolean nested) {
        Map<JComponent, List<JComponent>> componentMap = SwingUtils.getComponentMap(container, true);
        List<JComponent> components = componentMap.get(container);
        if (components != null) {
            for (JComponent component : componentMap.get(container)) {
                DefaultMutableTreeNode branch = new DefaultMutableTreeNode(component);
                branch.setUserObject(component);
                root.add(branch);
                if (!nested) continue;
                ComponentTreeModel.addNodes(component, model, branch, true);
            }
        }
    }
}

