/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ComponentTreeCellRenderer
extends DefaultTreeCellRenderer {
    private JTree tree;
    private double scale;
    private Map<JComponent, DefaultTreeCellRenderer> renderers;
    private final Color selColor;
    private final Color nonSelColor;

    public ComponentTreeCellRenderer(JTree tree, double scale) {
        this.tree = tree;
        this.scale = scale;
        this.setHorizontalTextPosition(2);
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.setFont(tree.getFont());
        this.renderers = new HashMap<JComponent, DefaultTreeCellRenderer>();
        this.selColor = this.backgroundSelectionColor == null ? Color.LIGHT_GRAY : new Color(this.backgroundSelectionColor.getRGB());
        this.nonSelColor = this.backgroundNonSelectionColor == null ? tree.getBackground() : this.backgroundNonSelectionColor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (userObject instanceof JComponent) {
            DefaultTreeCellRenderer renderer = null;
            JComponent component = (JComponent)node.getUserObject();
            if (!this.renderers.containsKey(component)) {
                renderer = this.rendererForComponent(component, tree);
                this.renderers.put(component, renderer);
            } else {
                renderer = this.renderers.get(component);
            }
            this.setIcon(renderer.getIcon());
            this.setText(renderer.getText());
        } else {
            this.setIcon(null);
            this.setText(String.valueOf(userObject));
        }
        this.setBackground(selected ? this.selColor : this.nonSelColor);
        return this;
    }

    private DefaultTreeCellRenderer rendererForComponent(JComponent component, JTree tree) {
        Rectangle visibleRect = component.getVisibleRect();
        String className = component.getClass().getName();
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setHorizontalTextPosition(2);
        if (component == tree) {
            renderer.setText(className + " (this tree)");
            return renderer;
        }
        if (!component.isShowing()) {
            renderer.setText(className + " (not visible)");
            return renderer;
        }
        if ((double)visibleRect.width * this.scale < 1.0 || (double)visibleRect.height * this.scale < 1.0) {
            renderer.setText(className + " (too small to show)");
            return renderer;
        }
        BufferedImage bi = new BufferedImage((int)((double)visibleRect.width * this.scale) + 2, (int)((double)visibleRect.height * this.scale) + 2, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setClip(visibleRect);
        g2.scale(this.scale, this.scale);
        try {
            Method method = JComponent.class.getDeclaredMethod("paintComponent", Graphics.class);
            method.setAccessible(true);
            method.invoke((Object)component, g2);
            method = JComponent.class.getDeclaredMethod("paintBorder", Graphics.class);
            method.setAccessible(true);
            method.invoke((Object)component, g2);
            if (SwingUtilities.isDescendingFrom(tree, component)) {
                g2.setColor(this.textNonSelectionColor);
                g2.scale(1.0 / this.scale, 1.0 / this.scale);
                g2.drawString("(Children not shown)", 2, 15);
            } else {
                method = JComponent.class.getDeclaredMethod("paintChildren", Graphics.class);
                method.setAccessible(true);
                method.invoke((Object)component, g2);
            }
        }
        catch (IllegalAccessException ignore) {
        }
        catch (IllegalArgumentException ignore) {
        }
        catch (InvocationTargetException ignore) {
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        g2.dispose();
        renderer.setText(className);
        renderer.setIcon(new ImageIcon(bi));
        return renderer;
    }

    public void refresh() {
        this.renderers.clear();
        this.tree.updateUI();
    }

    public void setScale(double scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.refresh();
        }
    }
}

