/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class ProtectedHighlighter
extends DefaultHighlighter {
    private Map<Highlighter.Highlight, Point> highlights = new HashMap<Highlighter.Highlight, Point>();
    private Highlighter.HighlightPainter painter;

    public ProtectedHighlighter(JTextComponent component, Color highlightColor) {
        this.setDrawsLayeredHighlights(false);
        component.setHighlighter(this);
        if (highlightColor == null) {
            Color color = component.getSelectionColor();
            int red = Math.min(255, (int)((double)color.getRed() * 1.2));
            int green = Math.min(255, (int)((double)color.getGreen() * 1.2));
            int blue = Math.min(255, (int)((double)color.getBlue() * 1.2));
            highlightColor = new Color(red, green, blue);
        }
        this.painter = new ProtectedHighlightPainter(component, highlightColor);
    }

    @Override
    public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
        Object tag = super.addHighlight(p0, p1, p);
        Highlighter.Highlight highlight = (Highlighter.Highlight)tag;
        Point pt = new Point(p0, p1 - p0);
        this.highlights.put(highlight, pt);
        return tag;
    }

    @Override
    public void removeHighlight(Object tag) {
        this.highlights.remove(tag);
        super.removeHighlight(tag);
    }

    public Object addHighlight(int p0, int p1) {
        Object tag = null;
        try {
            tag = this.addHighlight(p0, p1, this.painter);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return tag;
    }

    class ProtectedHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private JTextComponent component;
        private int lastLine;

        public ProtectedHighlightPainter(JTextComponent component, Color color) {
            super(color);
            this.component = component;
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            offs1 = this.getOffs1(offs0, offs1);
            Element root = c.getDocument().getDefaultRootElement();
            int line = root.getElementIndex(offs0);
            Element lineElement = root.getElement(line);
            int start = lineElement.getStartOffset();
            int end = lineElement.getEndOffset() - 1;
            if (offs0 == start && offs1 == end) {
                super.paint(g, offs0, offs1 + 1, bounds, c);
            } else {
                super.paint(g, offs0, offs1, bounds, c);
            }
        }

        private int getOffs1(int offs0, int offs1) {
            for (Map.Entry me : ProtectedHighlighter.this.highlights.entrySet()) {
                int start = ((Highlighter.Highlight)me.getKey()).getStartOffset();
                Point p = (Point)me.getValue();
                if (start != offs0) continue;
                return start + p.y;
            }
            return offs1;
        }
    }
}

