/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.text;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;

public class ProtectedDocument {
    private AbstractDocument doc;
    private Map<Position, Position> positions = new HashMap<Position, Position>();

    public ProtectedDocument(JTextComponent component) {
        this.doc = (AbstractDocument)component.getDocument();
        this.doc.setDocumentFilter(new ProtectedDocumentFilter());
        component.setNavigationFilter(new ProtectedNavigationFilter(component));
    }

    public void protect(int start, int end) {
        try {
            this.positions.put(this.doc.createPosition(start), this.doc.createPosition(end));
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
    }

    class ProtectedNavigationFilter
    extends NavigationFilter
    implements MouseListener {
        private JTextComponent component;
        private boolean isMousePressed = false;
        private int mouseDot = -1;
        private int lastDot = -1;

        public ProtectedNavigationFilter(JTextComponent component) {
            this.component = component;
            this.component.addMouseListener(this);
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            if (dot > this.lastDot) {
                dot = this.getForwardDot(dot);
                super.setDot(fb, dot, bias);
            } else {
                dot = this.getBackwardDot(dot);
                super.setDot(fb, dot, bias);
            }
            this.lastDot = dot;
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            int n = this.lastDot = this.isMousePressed ? this.mouseDot : this.lastDot;
            if (dot > this.lastDot) {
                this.lastDot = dot;
                dot = this.getForwardDot(dot);
                super.moveDot(fb, dot, bias);
            } else {
                this.lastDot = dot;
                dot = this.getBackwardDot(dot);
                super.moveDot(fb, dot, bias);
            }
            this.lastDot = dot;
        }

        private int getForwardDot(int dot) {
            for (Map.Entry me : ProtectedDocument.this.positions.entrySet()) {
                int positionStart = ((Position)me.getKey()).getOffset();
                int positionEnd = ((Position)me.getValue()).getOffset();
                if (dot <= positionStart || dot > positionEnd) continue;
                return positionEnd + 1;
            }
            return dot;
        }

        private int getBackwardDot(int dot) {
            for (Map.Entry me : ProtectedDocument.this.positions.entrySet()) {
                int positionStart = ((Position)me.getKey()).getOffset();
                int positionEnd = ((Position)me.getValue()).getOffset();
                if (dot > positionEnd || dot < positionStart) continue;
                return positionStart;
            }
            return dot;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.isMousePressed = true;
            this.mouseDot = this.component.getCaretPosition();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.isMousePressed = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    class ProtectedDocumentFilter
    extends DocumentFilter {
        ProtectedDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet a) throws BadLocationException {
            if (this.isInsertProtected(offset)) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                super.insertString(fb, offset, str, a);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String str, AttributeSet a) throws BadLocationException {
            if (length != 0 && this.isRemoveProtected(offset, length)) {
                Toolkit.getDefaultToolkit().beep();
            } else if (this.isInsertProtected(offset)) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                super.replace(fb, offset, length, str, a);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (length == 0) {
                ++length;
            }
            if (this.isRemoveProtected(offset, length)) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                super.remove(fb, offset, length);
            }
        }

        private boolean isRemoveProtected(int start, int length) {
            int end = start + length - 1;
            for (Map.Entry me : ProtectedDocument.this.positions.entrySet()) {
                int positionStart = ((Position)me.getKey()).getOffset();
                int positionEnd = ((Position)me.getValue()).getOffset();
                if (start >= positionStart && start <= positionEnd) {
                    return true;
                }
                if (end >= positionStart && end <= positionEnd) {
                    return true;
                }
                if (start >= positionStart || end <= positionEnd) continue;
                return true;
            }
            return false;
        }

        private boolean isInsertProtected(int start) {
            for (Map.Entry me : ProtectedDocument.this.positions.entrySet()) {
                int positionStart = ((Position)me.getKey()).getOffset();
                int positionEnd = ((Position)me.getValue()).getOffset();
                if (start == 0 && positionStart == 0) {
                    return true;
                }
                if (start <= positionStart || start > positionEnd) continue;
                return true;
            }
            return false;
        }
    }
}

