/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.table;

import com.wordpress.tipsforjava.swing.table.RowTableModel;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JButtonTableModel
extends RowTableModel<JButton> {
    private static String[] COLUMN_NAMES = new String[]{"Text", "Tool Tip Text", "Enabled", "Visible"};

    JButtonTableModel() {
        super(Arrays.asList(COLUMN_NAMES));
        this.setRowClass(JButton.class);
        this.setColumnClass(2, Boolean.class);
        this.setColumnClass(3, Boolean.class);
    }

    @Override
    public Object getValueAt(int row, int column) {
        JButton button = (JButton)this.getRow(row);
        switch (column) {
            case 0: {
                return button.getText();
            }
            case 1: {
                return button.getToolTipText();
            }
            case 2: {
                return button.isEnabled();
            }
            case 3: {
                return button.isVisible();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        JButton button = (JButton)this.getRow(row);
        switch (column) {
            case 0: {
                button.setText((String)value);
                break;
            }
            case 1: {
                button.setToolTipText((String)value);
                break;
            }
            case 2: {
                button.setEnabled((Boolean)value);
                break;
            }
            case 3: {
                button.setVisible((Boolean)value);
            }
        }
    }

    public static void main(String[] args) {
        JButton one = new JButton("One");
        JButton two = new JButton("Two");
        JButton three = new JButton("Three");
        JButtonTableModel model = new JButtonTableModel();
        model.addRow(one);
        model.addRow(two);
        model.addRow(three);
        JTable table = new JTable(model);
        table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        JPanel south = new JPanel();
        south.add(one);
        south.add(two);
        south.add(three);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(scrollPane);
        frame.getContentPane().add((Component)south, "South");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

